/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.service;

import com.google.common.collect.Lists;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.JndiLdapRealm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.JdbcUtils;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.realm.ActiveDirectoryGroupRealm;
import org.apache.zeppelin.realm.LdapRealm;
import org.apache.zeppelin.service.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroAuthenticationService
implements AuthenticationService {
    private final Logger LOGGER = LoggerFactory.getLogger(ShiroAuthenticationService.class);
    private final ZeppelinConfiguration conf;

    @Inject
    public ShiroAuthenticationService(ZeppelinConfiguration conf) throws Exception {
        this.LOGGER.info("ShiroAuthenticationService is initialized");
        this.conf = conf;
        if (conf.getShiroPath().length() > 0) {
            try {
                Collection realms = ((DefaultWebSecurityManager)SecurityUtils.getSecurityManager()).getRealms();
                if (realms.size() > 1) {
                    Boolean isIniRealmEnabled = false;
                    for (Realm realm : realms) {
                        if (!(realm instanceof IniRealm) || ((IniRealm)realm).getIni().get((Object)"users") == null) continue;
                        isIniRealmEnabled = true;
                        break;
                    }
                    if (isIniRealmEnabled.booleanValue()) {
                        throw new Exception("IniRealm/password based auth mechanisms should be exclusive. Consider removing [users] block from shiro.ini");
                    }
                }
            }
            catch (UnavailableSecurityManagerException e) {
                this.LOGGER.error("Failed to initialise shiro configuration", (Throwable)e);
            }
        }
    }

    @Override
    public String getPrincipal() {
        String principal;
        Subject subject = SecurityUtils.getSubject();
        if (subject.isAuthenticated()) {
            principal = this.extractPrincipal(subject);
            if (this.conf.isUsernameForceLowerCase()) {
                this.LOGGER.debug("Converting principal name " + principal + " to lower case:" + principal.toLowerCase());
                principal = principal.toLowerCase();
            }
        } else {
            principal = "anonymous";
        }
        return principal;
    }

    private String extractPrincipal(Subject subject) {
        Object principalObject = subject.getPrincipal();
        String principal = principalObject instanceof Principal ? ((Principal)principalObject).getName() : String.valueOf(principalObject);
        return principal;
    }

    @Override
    public Collection<Realm> getRealmsList() {
        String key = ThreadContext.SECURITY_MANAGER_KEY;
        DefaultWebSecurityManager defaultWebSecurityManager = (DefaultWebSecurityManager)ThreadContext.get((Object)key);
        return defaultWebSecurityManager.getRealms();
    }

    @Override
    public boolean isAuthenticated() {
        return SecurityUtils.getSubject().isAuthenticated();
    }

    @Override
    public List<String> getMatchedUsers(String searchText, int numUsersToFetch) {
        ArrayList<String> usersList = new ArrayList<String>();
        try {
            Collection<Realm> realmsList = this.getRealmsList();
            if (realmsList != null) {
                for (Realm realm : realmsList) {
                    String realClassName = realm.getClass().getName();
                    this.LOGGER.debug("RealmClass.getName: " + realClassName);
                    if (realClassName.equals("org.apache.shiro.realm.text.IniRealm")) {
                        usersList.addAll(this.getUserList((IniRealm)realm));
                        continue;
                    }
                    if (realClassName.equals("org.apache.zeppelin.realm.LdapGroupRealm")) {
                        usersList.addAll(this.getUserList((JndiLdapRealm)realm, searchText, numUsersToFetch));
                        continue;
                    }
                    if (realClassName.equals("org.apache.zeppelin.realm.LdapRealm")) {
                        usersList.addAll(this.getUserList((LdapRealm)realm, searchText, numUsersToFetch));
                        continue;
                    }
                    if (realClassName.equals("org.apache.zeppelin.realm.ActiveDirectoryGroupRealm")) {
                        usersList.addAll(this.getUserList((ActiveDirectoryGroupRealm)realm, searchText, numUsersToFetch));
                        continue;
                    }
                    if (!realClassName.equals("org.apache.shiro.realm.jdbc.JdbcRealm")) continue;
                    usersList.addAll(this.getUserList((JdbcRealm)realm));
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Exception in retrieving Users from realms ", (Throwable)e);
        }
        return usersList;
    }

    @Override
    public List<String> getMatchedRoles() {
        ArrayList<String> rolesList = new ArrayList<String>();
        try {
            Collection<Realm> realmsList = this.getRealmsList();
            if (realmsList != null) {
                for (Realm realm : realmsList) {
                    String name = realm.getClass().getName();
                    this.LOGGER.debug("RealmClass.getName: " + name);
                    if (name.equals("org.apache.shiro.realm.text.IniRealm")) {
                        rolesList.addAll(this.getRolesList((IniRealm)realm));
                        continue;
                    }
                    if (!name.equals("org.apache.zeppelin.realm.LdapRealm")) continue;
                    rolesList.addAll(this.getRolesList((LdapRealm)realm));
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Exception in retrieving Users from realms ", (Throwable)e);
        }
        return rolesList;
    }

    @Override
    public Set<String> getAssociatedRoles() {
        Subject subject = SecurityUtils.getSubject();
        HashSet<String> roles = new HashSet<String>();
        Map<String, String> allRoles = null;
        if (subject.isAuthenticated()) {
            Collection<Realm> realmsList = this.getRealmsList();
            for (Realm realm : realmsList) {
                String name = realm.getClass().getName();
                if (name.equals("org.apache.shiro.realm.text.IniRealm")) {
                    allRoles = ((IniRealm)realm).getIni().get((Object)"roles");
                    break;
                }
                if (name.equals("org.apache.zeppelin.realm.LdapRealm")) {
                    try {
                        AuthorizationInfo auth = ((LdapRealm)realm).queryForAuthorizationInfo((PrincipalCollection)new SimplePrincipalCollection(subject.getPrincipal(), realm.getName()), ((LdapRealm)realm).getContextFactory());
                        if (auth == null) break;
                        roles = new HashSet(auth.getRoles());
                    }
                    catch (NamingException e) {
                        this.LOGGER.error("Can't fetch roles", (Throwable)e);
                    }
                    break;
                }
                if (!name.equals("org.apache.zeppelin.realm.ActiveDirectoryGroupRealm")) continue;
                allRoles = ((ActiveDirectoryGroupRealm)realm).getListRoles();
                break;
            }
            if (allRoles != null) {
                for (Map.Entry pair : allRoles.entrySet()) {
                    if (!subject.hasRole((String)pair.getKey())) continue;
                    roles.add((String)pair.getKey());
                }
            }
        }
        return roles;
    }

    private List<String> getUserList(IniRealm r) {
        ArrayList<String> userList = new ArrayList<String>();
        Ini.Section getIniUser = r.getIni().get((Object)"users");
        if (getIniUser != null) {
            for (Map.Entry pair : getIniUser.entrySet()) {
                userList.add(pair.getKey().toString().trim());
            }
        }
        return userList;
    }

    private List<String> getRolesList(IniRealm r) {
        ArrayList<String> roleList = new ArrayList<String>();
        Ini.Section getIniRoles = r.getIni().get((Object)"roles");
        if (getIniRoles != null) {
            for (Map.Entry pair : getIniRoles.entrySet()) {
                roleList.add(pair.getKey().toString().trim());
            }
        }
        return roleList;
    }

    private List<String> getUserList(JndiLdapRealm r, String searchText, int numUsersToFetch) {
        ArrayList<String> userList = new ArrayList<String>();
        String userDnTemplate = r.getUserDnTemplate();
        String[] userDn = userDnTemplate.split(",", 2);
        String userDnPrefix = userDn[0].split("=")[0];
        String userDnSuffix = userDn[1];
        JndiLdapContextFactory cf = (JndiLdapContextFactory)r.getContextFactory();
        try {
            LdapContext ctx = cf.getSystemLdapContext();
            SearchControls constraints = new SearchControls();
            constraints.setCountLimit(numUsersToFetch);
            constraints.setSearchScope(2);
            String[] attrIDs = new String[]{userDnPrefix};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> result = ctx.search(userDnSuffix, "(" + userDnPrefix + "=*" + searchText + "*)", constraints);
            while (result.hasMore()) {
                Attributes attrs = result.next().getAttributes();
                if (attrs.get(userDnPrefix) == null) continue;
                String currentUser = attrs.get(userDnPrefix).toString();
                userList.add(currentUser.split(":")[1].trim());
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error retrieving User list from Ldap Realm", (Throwable)e);
        }
        this.LOGGER.info("UserList: " + userList);
        return userList;
    }

    private List<String> getUserList(LdapRealm r, String searchText, int numUsersToFetch) {
        ArrayList<String> userList = new ArrayList<String>();
        this.LOGGER.debug("SearchText: " + searchText);
        String userAttribute = r.getUserSearchAttributeName();
        String userSearchRealm = r.getUserSearchBase();
        String userObjectClass = r.getUserObjectClass();
        JndiLdapContextFactory cf = (JndiLdapContextFactory)r.getContextFactory();
        try {
            LdapContext ctx = cf.getSystemLdapContext();
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setCountLimit(numUsersToFetch);
            String[] attrIDs = new String[]{userAttribute};
            constraints.setReturningAttributes(attrIDs);
            NamingEnumeration<SearchResult> result = ctx.search(userSearchRealm, "(&(objectclass=" + userObjectClass + ")(" + userAttribute + "=*" + searchText + "*))", constraints);
            while (result.hasMore()) {
                String currentUser;
                Attributes attrs = result.next().getAttributes();
                if (attrs.get(userAttribute) == null) continue;
                if (r.getUserLowerCase()) {
                    this.LOGGER.debug("userLowerCase true");
                    currentUser = ((String)attrs.get(userAttribute).get()).toLowerCase();
                } else {
                    this.LOGGER.debug("userLowerCase false");
                    currentUser = (String)attrs.get(userAttribute).get();
                }
                this.LOGGER.debug("CurrentUser: " + currentUser);
                userList.add(currentUser.trim());
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error retrieving User list from Ldap Realm", (Throwable)e);
        }
        return userList;
    }

    private List<String> getRolesList(LdapRealm r) {
        ArrayList<String> roleList = new ArrayList<String>();
        Map<String, String> roles = r.getListRoles();
        if (roles != null) {
            for (Map.Entry<String, String> pair : roles.entrySet()) {
                this.LOGGER.debug("RoleKeyValue: " + pair.getKey() + " = " + pair.getValue());
                roleList.add(pair.getKey());
            }
        }
        return roleList;
    }

    private List<String> getUserList(ActiveDirectoryGroupRealm r, String searchText, int numUsersToFetch) {
        List<String> userList = new ArrayList<String>();
        try {
            LdapContext ctx = r.getLdapContextFactory().getSystemLdapContext();
            userList = r.searchForUserName(searchText, ctx, numUsersToFetch);
        }
        catch (Exception e) {
            this.LOGGER.error("Error retrieving User list from ActiveDirectory Realm", (Throwable)e);
        }
        return userList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUserList(JdbcRealm obj) {
        String userquery;
        ArrayList<String> userlist = new ArrayList<String>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        DataSource dataSource = null;
        String authQuery = "";
        String tablename = "";
        String username = "";
        try {
            dataSource = (DataSource)FieldUtils.readField((Object)obj, (String)"dataSource", (boolean)true);
            authQuery = (String)FieldUtils.readField((Object)obj, (String)"authenticationQuery", (boolean)true);
            this.LOGGER.info(authQuery);
            String authQueryLowerCase = authQuery.toLowerCase();
            String[] retval = authQueryLowerCase.split("from", 2);
            if (retval.length >= 2) {
                retval = retval[1].split("with|where", 2);
                tablename = retval[0];
                retval = (retval = retval[1].split("where", 2)).length >= 2 ? retval[1].split("=", 2) : retval[0].split("=", 2);
                username = retval[0];
            }
            if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)tablename)) {
                return userlist;
            }
            userquery = String.format("SELECT %s FROM %s", username, tablename);
        }
        catch (IllegalAccessException e) {
            this.LOGGER.error("Error while accessing dataSource for JDBC Realm", (Throwable)e);
            return Lists.newArrayList();
        }
        try {
            con = dataSource.getConnection();
            ps = con.prepareStatement(userquery);
            rs = ps.executeQuery();
            while (rs.next()) {
                userlist.add(rs.getString(1).trim());
            }
        }
        catch (Exception e) {
            try {
                this.LOGGER.error("Error retrieving User list from JDBC Realm", (Throwable)e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection((Connection)con);
                throw throwable;
            }
            JdbcUtils.closeResultSet((ResultSet)rs);
            JdbcUtils.closeStatement((Statement)ps);
            JdbcUtils.closeConnection((Connection)con);
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)ps);
        JdbcUtils.closeConnection((Connection)con);
        return userlist;
    }
}

