/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.Iterator;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.asm.IProgramElement;

public abstract class StructureView {
    private IStructureViewNode rootNode = null;
    private IStructureViewNode activeNode = null;
    protected StructureViewProperties viewProperties = null;
    protected StructureViewRenderer renderer = null;

    public StructureViewProperties getViewProperties() {
        return this.viewProperties;
    }

    public IStructureViewNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(IStructureViewNode rootNode) {
        this.rootNode = rootNode;
    }

    public void setViewProperties(StructureViewProperties viewProperties) {
        this.viewProperties = viewProperties;
    }

    public void setRenderer(StructureViewRenderer renderer) {
        this.renderer = renderer;
    }

    protected void notifyViewUpdated() {
        if (this.renderer != null) {
            this.renderer.updateView(this);
        }
    }

    public IStructureViewNode getActiveNode() {
        if (this.activeNode != null && this.activeNode.getStructureNode() != null) {
            return this.activeNode;
        }
        return null;
    }

    public IStructureViewNode findCorrespondingViewNode(IProgramElement node) {
        return this.findCorrespondingViewNodeHelper(this.rootNode, node);
    }

    private IStructureViewNode findCorrespondingViewNodeHelper(IStructureViewNode node, IProgramElement pNode) {
        if (node != null && node.getStructureNode() != null && node.getStructureNode().equals(pNode) && node.getKind() == IStructureViewNode.Kind.DECLARATION) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                IStructureViewNode foundNode = this.findCorrespondingViewNodeHelper((IStructureViewNode)it.next(), pNode);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    public void setActiveNode(IStructureViewNode activeNode) {
        this.activeNode = activeNode;
        if (this.renderer != null) {
            this.renderer.setActiveNode(activeNode);
        }
    }

    public void setActiveNode(IStructureViewNode activeNode, int sourceLine) {
        this.activeNode = activeNode;
        if (this.renderer != null) {
            this.renderer.setActiveNode(activeNode, sourceLine);
        }
    }
}

