/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search;

import java.util.LinkedHashSet;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModel;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.ITypeHierarchy;
import org.aspectj.org.eclipse.jdt.core.ITypeRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.aspectj.org.eclipse.jdt.internal.core.builder.State;
import org.aspectj.org.eclipse.jdt.internal.core.index.IndexLocation;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class IndexSelector {
    public static final int PROJECT_CAN_SEE_FOCUS = 0;
    public static final int PROJECT_SOURCE_CAN_NOT_SEE_FOCUS = 1;
    public static final int PROJECT_CAN_NOT_SEE_FOCUS = 2;
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IndexLocation[] indexLocations;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int canSeeFocus(SearchPattern pattern, IPath projectOrJarPath) {
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject project = IndexSelector.getJavaProject(projectOrJarPath, model);
            IJavaElement[] focuses = IndexSelector.getFocusedElementsAndTypes(pattern, project, null);
            if (focuses.length == 0) {
                return 2;
            }
            if (project != null) {
                return IndexSelector.canSeeFocus(focuses, (JavaProject)project, null);
            }
            int result = 2;
            IJavaProject[] allProjects = model.getJavaProjects();
            int i = 0;
            int length = allProjects.length;
            while (true) {
                if (i >= length) {
                    return result;
                }
                JavaProject otherProject = (JavaProject)allProjects[i];
                IClasspathEntry entry = otherProject.getClasspathEntryFor(projectOrJarPath);
                if (entry != null && entry.getEntryKind() == 1) {
                    int canSeeFocus = IndexSelector.canSeeFocus(focuses, otherProject, null);
                    if (canSeeFocus == 0) {
                        return 0;
                    }
                    if (canSeeFocus == 1) {
                        result = 1;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            return 2;
        }
    }

    private static int canSeeFocus(IJavaElement[] focuses, JavaProject javaProject, char[][][] focusQualifiedNames) {
        int result = 2;
        int length = focuses.length;
        int i = 0;
        while (i < length) {
            int canSeeFocus = IndexSelector.canSeeFocus(focuses[i], javaProject, focusQualifiedNames);
            if (canSeeFocus == 0) {
                return 0;
            }
            if (canSeeFocus == 1) {
                result = 1;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int canSeeFocus(IJavaElement focus, JavaProject javaProject, char[][][] focusQualifiedNames) {
        try {
            if (focus == null) {
                return 2;
            }
            if (focus.equals(javaProject)) {
                return 0;
            }
            if (focus instanceof JarPackageFragmentRoot) {
                IPath focusPath = focus.getPath();
                IClasspathEntry[] entries = javaProject.getExpandedClasspath();
                int i = 0;
                int length = entries.length;
                while (i < length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals(focusPath)) {
                        return 0;
                    }
                    ++i;
                }
                return 2;
            }
            IPath focusPath = ((JavaProject)focus).getProject().getFullPath();
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            int i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals(focusPath)) {
                    State projectState;
                    if (focusQualifiedNames != null && (projectState = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(javaProject.getProject(), null)) != null) {
                        Object[] values = projectState.getReferences().valueTable;
                        int vLength = values.length;
                        int j = 0;
                        while (j < vLength) {
                            ReferenceCollection references;
                            if (values[j] != null && (references = (ReferenceCollection)values[j]).includes(focusQualifiedNames, null, null)) {
                                return 0;
                            }
                            ++j;
                        }
                        return 1;
                    }
                    return 0;
                }
                ++i;
            }
            return 2;
        }
        catch (JavaModelException e) {
            return 2;
        }
    }

    private static IJavaElement[] getFocusedElementsAndTypes(SearchPattern pattern, IJavaElement focusElement, ObjectVector superTypes) throws JavaModelException {
        if (pattern instanceof MethodPattern) {
            IType type = (IType)pattern.focus.getAncestor(7);
            MethodPattern methodPattern = (MethodPattern)pattern;
            String selector = new String(methodPattern.selector);
            int parameterCount = methodPattern.parameterCount;
            ITypeHierarchy superHierarchy = type.newSupertypeHierarchy(null);
            IType[] allTypes = superHierarchy.getAllSupertypes(type);
            int length = allTypes.length;
            SimpleSet focusSet = new SimpleSet(length + 1);
            if (focusElement != null) {
                focusSet.add(focusElement);
            }
            int i = 0;
            while (i < length) {
                IMethod[] methods = allTypes[i].getMethods();
                int mLength = methods.length;
                int m = 0;
                while (m < mLength) {
                    if (parameterCount == methods[m].getNumberOfParameters() && methods[m].getElementName().equals(selector)) {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)allTypes[i].getAncestor(3);
                        IJavaElement element = root.isArchive() ? root : root.getParent();
                        focusSet.add(element);
                        if (superTypes == null) break;
                        superTypes.add(allTypes[i]);
                        break;
                    }
                    ++m;
                }
                ++i;
            }
            IJavaElement[] focuses = new IJavaElement[focusSet.elementSize];
            Object[] values = focusSet.values;
            int count = 0;
            int i2 = values.length;
            while (--i2 >= 0) {
                if (values[i2] == null) continue;
                focuses[count++] = (IJavaElement)values[i2];
            }
            return focuses;
        }
        if (focusElement == null) {
            return new IJavaElement[0];
        }
        return new IJavaElement[]{focusElement};
    }

    /*
     * Unable to fully structure code
     */
    private void initializeIndexLocations() {
        projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        manager = JavaModelManager.getIndexManager();
        locations = new LinkedHashSet<IndexLocation>();
        focus = MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            i = 0;
            while (i < projectsAndJars.length) {
                path = projectsAndJars[i];
                target = JavaModel.getTarget(path, false);
                if (target instanceof IFolder) {
                    path = ((IFolder)target).getFullPath();
                }
                locations.add(manager.computeIndexLocation(path));
                ++i;
            }
        } else {
            try {
                length = projectsAndJars.length;
                projectsCanSeeFocus = new JavaProject[length];
                visitedProjects = new SimpleSet(length);
                projectIndex = 0;
                externalLibsToCheck = new SimpleSet(length);
                superTypes = new ObjectVector();
                focuses = IndexSelector.getFocusedElementsAndTypes(this.pattern, focus, superTypes);
                focusQualifiedNames = null;
                isAutoBuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
                if (isAutoBuilding && focus instanceof IJavaProject) {
                    focusQualifiedNames = this.getQualifiedNames(superTypes);
                }
                model = JavaModelManager.getJavaModelManager().getJavaModel();
                i = 0;
                while (i < length) {
                    path = projectsAndJars[i];
                    project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        canSeeFocus = IndexSelector.canSeeFocus(focuses, project, focusQualifiedNames);
                        if (canSeeFocus == 0) {
                            locations.add(manager.computeIndexLocation(path));
                        }
                        if (canSeeFocus != 2) {
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        externalLibsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && externalLibsToCheck.elementSize > 0) {
                    entries = projectsCanSeeFocus[i].getResolvedClasspath();
                    j = entries.length;
                    while (--j >= 0) {
                        entry = entries[j];
                        if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                        target = JavaModel.getTarget(path, false);
                        if (target instanceof IFolder) {
                            path = ((IFolder)target).getFullPath();
                        }
                        locations.add(manager.computeIndexLocation(path));
                    }
                    ++i;
                }
                if (externalLibsToCheck.elementSize <= 0) ** GOTO lbl86
                allProjects = model.getJavaProjects();
                i = 0;
                l = allProjects.length;
                while (i < l && externalLibsToCheck.elementSize > 0) {
                    project = (JavaProject)allProjects[i];
                    if (!visitedProjects.includes(project)) {
                        entries = project.getResolvedClasspath();
                        j = entries.length;
                        while (--j >= 0) {
                            entry = entries[j];
                            if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                            target = JavaModel.getTarget(path, false);
                            if (target instanceof IFolder) {
                                path = ((IFolder)target).getFullPath();
                            }
                            locations.add(manager.computeIndexLocation(path));
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException var5_7) {
                // empty catch block
            }
        }
lbl86:
        // 4 sources

        locations.remove(null);
        this.indexLocations = locations.toArray(new IndexLocation[locations.size()]);
    }

    public IndexLocation[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project = model.getJavaProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }

    private char[][][] getQualifiedNames(ObjectVector types) {
        IType primaryType;
        int size = types.size;
        Object focusQualifiedNames = null;
        IJavaElement javaElement = this.pattern.focus;
        int index = 0;
        while (javaElement != null && !(javaElement instanceof ITypeRoot)) {
            javaElement = javaElement.getParent();
        }
        if (javaElement != null && (primaryType = ((ITypeRoot)javaElement).findPrimaryType()) != null) {
            focusQualifiedNames = new char[size + 1][][];
            focusQualifiedNames[index++] = CharOperation.splitOn('.', primaryType.getFullyQualifiedName().toCharArray());
        }
        if (focusQualifiedNames == null) {
            focusQualifiedNames = new char[size][][];
        }
        int i = 0;
        while (i < size) {
            focusQualifiedNames[index++] = CharOperation.splitOn('.', ((IType)types.elementAt(i)).getFullyQualifiedName().toCharArray());
            ++i;
        }
        return ((char[][][])focusQualifiedNames).length == 0 ? null : ReferenceCollection.internQualifiedNames(focusQualifiedNames, true);
    }
}

