/*******************************************************************************
 * Copyright (c) 2000, 2022 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
							TokenNameWHITESPACE = 1000,
							TokenNameCOMMENT_LINE = 1001,
							TokenNameCOMMENT_BLOCK = 1002,
							TokenNameCOMMENT_JAVADOC = 1003,
							TokenNameSingleQuoteStringLiteral = 1004;

	static boolean isRestrictedKeyword(int tokenType) {
		return switch (tokenType) {
			case TokenNameRestrictedIdentifierYield, TokenNameRestrictedIdentifierrecord,TokenNameRestrictedIdentifierWhen,
					TokenNameRestrictedIdentifiersealed, TokenNameRestrictedIdentifierpermits -> true;
			default -> false;
		};
	}

	static int getRestrictedKeyword(char [] text) {
		if (text != null) {
			int len = text.length;
			if (len == 4 && text[0] == 'w' ||
				len == 5 && text[0] == 'y' ||
				len == 6 && (text[0] == 'r' || text[0] == 's') ||
				len == 7 && text[0] == 'p') {
				return getRestrictedKeyword(new String(text));
			}
		}
		return TokenNameNotAToken;
	}

	static int getRestrictedKeyword(String text) {
		return switch (text) {
			case "yield"   -> TokenNameRestrictedIdentifierYield;   //$NON-NLS-1$
			case "record"  -> TokenNameRestrictedIdentifierrecord;  //$NON-NLS-1$
			case "when"    -> TokenNameRestrictedIdentifierWhen;    //$NON-NLS-1$
			case "sealed"  -> TokenNameRestrictedIdentifiersealed;  //$NON-NLS-1$
			case "permits" -> TokenNameRestrictedIdentifierpermits; //$NON-NLS-1$
			default        -> TokenNameNotAToken;
		};
	}

	// AspectJ: Tokens taken from javasym.java, generated by jikespg according to
	// https://www.eclipse.org/jdt/core/howto/generate%20parser/generateParser.html
	//
	// TODO Every time when updating tokens, make sure to rename
	//   - TokenName$eof -> TokenNameEOF
	//   - TokenName$error -> TokenNameERROR
	//   - TokenNamenon-sealed -> TokenNamenon_sealed
	int
		TokenNameIdentifier = 16,
		TokenNameabstract = 48,
		TokenNameassert = 86,
		TokenNameboolean = 119,
		TokenNamebreak = 87,
		TokenNamebyte = 120,
		TokenNamecase = 95,
		TokenNamecatch = 97,
		TokenNamechar = 121,
		TokenNameclass = 75,
		TokenNamecontinue = 88,
		TokenNameconst = 145,
		TokenNamedefault = 100,
		TokenNamedo = 89,
		TokenNamedouble = 122,
		TokenNameelse = 104,
		TokenNameenum = 82,
		TokenNameextends = 96,
		TokenNamefalse = 61,
		TokenNamefinal = 49,
		TokenNamefinally = 101,
		TokenNamefloat = 123,
		TokenNamefor = 90,
		TokenNamegoto = 146,
		TokenNameif = 91,
		TokenNameimplements = 106,
		TokenNameimport = 98,
		TokenNameinstanceof = 14,
		TokenNameint = 124,
		TokenNameinterface = 81,
		TokenNamelong = 125,
		TokenNamenative = 50,
		TokenNamenew = 42,
		TokenNamenon_sealed = 51,
		TokenNamenull = 62,
		TokenNamepackage = 94,
		TokenNameprivate = 52,
		TokenNameprotected = 53,
		TokenNamepublic = 54,
		TokenNamereturn = 92,
		TokenNameshort = 126,
		TokenNamestatic = 43,
		TokenNamestrictfp = 55,
		TokenNamesuper = 45,
		TokenNameswitch = 70,
		TokenNamesynchronized = 44,
		TokenNamethis = 46,
		TokenNamethrow = 83,
		TokenNamethrows = 102,
		TokenNametransient = 56,
		TokenNametrue = 63,
		TokenNametry = 93,
		TokenNamevoid = 127,
		TokenNamevolatile = 57,
		TokenNamewhile = 84,
		TokenNamemodule = 128,
		TokenNameopen = 129,
		TokenNamerequires = 132,
		TokenNametransitive = 138,
		TokenNameexports = 133,
		TokenNameopens = 134,
		TokenNameto = 143,
		TokenNameuses = 135,
		TokenNameprovides = 136,
		TokenNamewith = 144,
		TokenNameaspect = 26,
		TokenNamepointcut = 29,
		TokenNamearound = 34,
		TokenNamebefore = 31,
		TokenNameafter = 32,
		TokenNamedeclare = 33,
		TokenNameprivileged = 28,
		TokenNameIntegerLiteral = 64,
		TokenNameLongLiteral = 65,
		TokenNameFloatingPointLiteral = 66,
		TokenNameDoubleLiteral = 67,
		TokenNameCharacterLiteral = 68,
		TokenNameStringLiteral = 58,
		TokenNameTextBlock = 59,
		TokenNameStringTemplate = 130,
		TokenNameTextBlockTemplate = 131,
		TokenNamePLUS_PLUS = 3,
		TokenNameMINUS_MINUS = 4,
		TokenNameEQUAL_EQUAL = 23,
		TokenNameLESS_EQUAL = 17,
		TokenNameGREATER_EQUAL = 18,
		TokenNameNOT_EQUAL = 20,
		TokenNameLEFT_SHIFT = 21,
		TokenNameRIGHT_SHIFT = 12,
		TokenNameUNSIGNED_RIGHT_SHIFT = 15,
		TokenNamePLUS_EQUAL = 107,
		TokenNameMINUS_EQUAL = 108,
		TokenNameMULTIPLY_EQUAL = 109,
		TokenNameDIVIDE_EQUAL = 110,
		TokenNameAND_EQUAL = 111,
		TokenNameOR_EQUAL = 112,
		TokenNameXOR_EQUAL = 113,
		TokenNameREMAINDER_EQUAL = 114,
		TokenNameLEFT_SHIFT_EQUAL = 115,
		TokenNameRIGHT_SHIFT_EQUAL = 116,
		TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 117,
		TokenNameOR_OR = 38,
		TokenNameAND_AND = 37,
		TokenNamePLUS = 2,
		TokenNameMINUS = 6,
		TokenNameNOT = 73,
		TokenNameREMAINDER = 10,
		TokenNameXOR = 30,
		TokenNameAND = 22,
		TokenNameMULTIPLY = 8,
		TokenNameOR = 35,
		TokenNameTWIDDLE = 76,
		TokenNameDIVIDE = 11,
		TokenNameGREATER = 13,
		TokenNameLESS = 7,
		TokenNameLPAREN = 19,
		TokenNameRPAREN = 24,
		TokenNameLBRACE = 60,
		TokenNameRBRACE = 40,
		TokenNameLBRACKET = 5,
		TokenNameRBRACKET = 74,
		TokenNameSEMICOLON = 25,
		TokenNameQUESTION = 36,
		TokenNameCOLON = 69,
		TokenNameCOMMA = 39,
		TokenNameDOT = 1,
		TokenNameEQUAL = 78,
		TokenNameAT = 41,
		TokenNameELLIPSIS = 103,
		TokenNameARROW = 118,
		TokenNameCOLON_COLON = 9,
		TokenNameBeginLambda = 71,
		TokenNameBeginIntersectionCast = 77,
		TokenNameBeginTypeArguments = 99,
		TokenNameElidedSemicolonAndRightBrace = 79,
		TokenNameAT308 = 27,
		TokenNameAT308DOTDOTDOT = 139,
		TokenNameBeginCaseExpr = 80,
		TokenNameRestrictedIdentifierYield = 105,
		TokenNameRestrictedIdentifierrecord = 85,
		TokenNameRestrictedIdentifiersealed = 47,
		TokenNameRestrictedIdentifierpermits = 137,
		TokenNameBeginCaseElement = 140,
		TokenNameRestrictedIdentifierWhen = 141,
		TokenNameBeginRecordPattern = 142,
		TokenNameEOF = 72,
		TokenNameERROR = 147;
}
