/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.db;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.core.runtime.CoreException;

public class NdStringSet {
    private final Database db;
    private long ptr;
    private long head;
    private long loaded;
    private Map<String, Long> lazyCache;

    public NdStringSet(Database db, long ptr) throws CoreException {
        this.db = db;
        this.ptr = ptr;
        this.head = 0L;
        this.loaded = 0L;
    }

    public void clearCaches() {
        this.head = 0L;
        this.loaded = 0L;
        if (this.lazyCache != null) {
            this.lazyCache = null;
        }
    }

    private long getHead() throws CoreException {
        if (this.head == 0L) {
            this.head = this.db.getRecPtr(this.ptr);
        }
        return this.head;
    }

    public long add(String str) throws CoreException {
        long record = this.find(str);
        if (record != 0L) {
            return record;
        }
        IString string = this.db.newString(str);
        record = string.getRecord();
        long new_node = this.db.malloc(NodeType.sizeof, (short)6);
        NodeType.Next.put(this.db, new_node, this.getHead());
        NodeType.Item.put(this.db, new_node, record);
        if (this.lazyCache == null) {
            this.lazyCache = new HashMap<String, Long>();
        }
        this.lazyCache.put(str, record);
        this.head = new_node;
        if (this.loaded == 0L) {
            this.loaded = new_node;
        }
        this.db.putRecPtr(this.ptr, new_node);
        return record;
    }

    public long find(String str) throws CoreException {
        Long l;
        if (this.lazyCache != null && (l = this.lazyCache.get(str)) != null) {
            return l;
        }
        if (this.getHead() == 0L) {
            return 0L;
        }
        if (this.lazyCache == null) {
            this.lazyCache = new HashMap<String, Long>();
        }
        long curr = this.loaded == 0L ? this.getHead() : NodeType.Next.get(this.db, this.loaded);
        while (curr != 0L) {
            long next = NodeType.Next.get(this.db, curr);
            long item = NodeType.Item.get(this.db, curr);
            IString string = this.db.getString(item);
            this.lazyCache.put(string.getString(), item);
            if (string.compare(str, true) == 0) {
                return item;
            }
            this.loaded = curr;
            curr = next;
        }
        return 0L;
    }

    public long remove(String str) throws CoreException {
        if (this.lazyCache != null) {
            this.lazyCache.remove(str);
        }
        long prev = 0L;
        long curr = this.getHead();
        while (curr != 0L) {
            long next = NodeType.Next.get(this.db, curr);
            long item = NodeType.Item.get(this.db, curr);
            IString string = this.db.getString(item);
            if (string.compare(str, true) == 0) {
                if (this.head != curr) {
                    NodeType.Next.put(this.db, prev, next);
                } else {
                    this.db.putRecPtr(this.ptr, next);
                    this.head = next;
                }
                this.db.free(curr, (short)6);
                return item;
            }
            prev = curr;
            curr = next;
        }
        return 0L;
    }

    private static enum NodeType {
        Next,
        Item,
        _last;

        public final long offset = this.ordinal() * 4;
        public static final int sizeof;

        static {
            sizeof = (int)NodeType._last.offset;
        }

        public long get(Database db, long instance) throws CoreException {
            return db.getRecPtr(instance + this.offset);
        }

        public void put(Database db, long instance, long value) throws CoreException {
            db.putRecPtr(instance + this.offset, value);
        }
    }
}

