/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.loadtime.ClassLoaderWeavingAdaptor;
import org.aspectj.weaver.loadtime.ClassPreProcessor;
import org.aspectj.weaver.loadtime.IWeavingContext;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;
import org.aspectj.weaver.tools.WeavingAdaptor;

public class Aj
implements ClassPreProcessor {
    private IWeavingContext weavingContext;
    private static ReferenceQueue adaptorQueue = new ReferenceQueue();
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(Aj.class);
    private static final String deleLoader = "sun.reflect.DelegatingClassLoader";
    static /* synthetic */ Class class$0;

    static {
        new ExplicitlyInitializedClassLoaderWeavingAdaptor(new ClassLoaderWeavingAdaptor());
    }

    public Aj() {
        this(null);
    }

    public Aj(IWeavingContext context) {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, new Object[]{context, this.getClass().getClassLoader()});
        }
        this.weavingContext = context;
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public byte[] preProcess(String className, byte[] bytes, ClassLoader loader) {
        if (loader == null) return bytes;
        if (className == null) return bytes;
        if (loader.getClass().getName().equals(deleLoader)) {
            return bytes;
        }
        if (trace.isTraceEnabled()) {
            trace.enter("preProcess", (Object)this, new Object[]{className, bytes, loader});
        }
        if (trace.isTraceEnabled()) {
            trace.event("preProcess", (Object)this, new Object[]{loader.getParent(), Thread.currentThread().getContextClassLoader()});
        }
        try {
            try {
                WeavingAdaptor weavingAdaptor;
                block14: {
                    ClassLoader classLoader = loader;
                    // MONITORENTER : classLoader
                    weavingAdaptor = WeaverContainer.getWeaver(loader, this.weavingContext);
                    if (weavingAdaptor != null) break block14;
                    if (trace.isTraceEnabled()) {
                        trace.exit("preProcess");
                    }
                    byte[] byArray = bytes;
                    // MONITOREXIT : classLoader
                    CompilationAndWeavingContext.resetForThread();
                    return byArray;
                }
                byte[] newBytes = weavingAdaptor.weaveClass(className, bytes, false);
                Dump.dumpOnExit(weavingAdaptor.getMessageHolder(), true);
                if (trace.isTraceEnabled()) {
                    trace.exit("preProcess", newBytes);
                }
                byte[] byArray = newBytes;
                // MONITOREXIT : classLoader
                CompilationAndWeavingContext.resetForThread();
                return byArray;
            }
            catch (Throwable th) {
                trace.error(className, th);
                Dump.dumpWithException(th);
                if (trace.isTraceEnabled()) {
                    trace.exit("preProcess", th);
                }
                byte[] byArray = bytes;
                CompilationAndWeavingContext.resetForThread();
                return byArray;
            }
        }
        catch (Throwable throwable) {
            CompilationAndWeavingContext.resetForThread();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeStaleAdaptors(boolean displayProgress) {
        int removed = 0;
        Map map = WeaverContainer.weavingAdaptors;
        synchronized (map) {
            if (displayProgress) {
                System.err.println("Weaver adaptors before queue processing:");
                Map m = WeaverContainer.weavingAdaptors;
                Set keys = m.keySet();
                for (Object object : keys) {
                    System.err.println(object + " = " + WeaverContainer.weavingAdaptors.get(object));
                }
            }
            Reference o = adaptorQueue.poll();
            while (o != null) {
                AdaptorKey wo;
                boolean didit;
                if (displayProgress) {
                    System.err.println("Processing referencequeue entry " + o);
                }
                boolean bl = didit = WeaverContainer.weavingAdaptors.remove(wo = (AdaptorKey)o) != null;
                if (didit) {
                    ++removed;
                } else {
                    throw new RuntimeException("Eh?? key=" + wo);
                }
                if (displayProgress) {
                    System.err.println("Removed? " + didit);
                }
                o = adaptorQueue.poll();
            }
            if (displayProgress) {
                System.err.println("Weaver adaptors after queue processing:");
                Map m = WeaverContainer.weavingAdaptors;
                Set keys = m.keySet();
                for (Object object : keys) {
                    System.err.println(object + " = " + WeaverContainer.weavingAdaptors.get(object));
                }
            }
        }
        return removed;
    }

    public static int getActiveAdaptorCount() {
        return WeaverContainer.weavingAdaptors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkQ() {
        ReferenceQueue referenceQueue = adaptorQueue;
        synchronized (referenceQueue) {
            Reference o = adaptorQueue.poll();
            while (o != null) {
                AdaptorKey wo = (AdaptorKey)o;
                WeaverContainer.weavingAdaptors.remove(wo);
                o = adaptorQueue.poll();
            }
        }
    }

    public String getNamespace(ClassLoader loader) {
        ClassLoaderWeavingAdaptor weavingAdaptor = (ClassLoaderWeavingAdaptor)WeaverContainer.getWeaver(loader, this.weavingContext);
        return weavingAdaptor.getNamespace();
    }

    public boolean generatedClassesExist(ClassLoader loader) {
        return ((ClassLoaderWeavingAdaptor)WeaverContainer.getWeaver(loader, this.weavingContext)).generatedClassesExistFor(null);
    }

    public void flushGeneratedClasses(ClassLoader loader) {
        ((ClassLoaderWeavingAdaptor)WeaverContainer.getWeaver(loader, this.weavingContext)).flushGeneratedClasses();
    }

    private static class AdaptorKey
    extends WeakReference {
        private int hashcode = -1;

        public AdaptorKey(ClassLoader loader) {
            super(loader, adaptorQueue);
            this.hashcode = loader.hashCode() * 37;
        }

        public ClassLoader getClassLoader() {
            ClassLoader instance = (ClassLoader)this.get();
            return instance;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AdaptorKey)) {
                return false;
            }
            AdaptorKey other = (AdaptorKey)obj;
            return other.hashcode == this.hashcode;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    static class WeaverContainer {
        static final Map weavingAdaptors = Collections.synchronizedMap(new HashMap());

        WeaverContainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static WeavingAdaptor getWeaver(ClassLoader loader, IWeavingContext weavingContext) {
            ExplicitlyInitializedClassLoaderWeavingAdaptor adaptor = null;
            AdaptorKey adaptorKey = new AdaptorKey(loader);
            loader.getClass().getName();
            Map map = weavingAdaptors;
            synchronized (map) {
                Aj.checkQ();
                adaptor = (ExplicitlyInitializedClassLoaderWeavingAdaptor)weavingAdaptors.get(adaptorKey);
                if (adaptor == null) {
                    ClassLoaderWeavingAdaptor weavingAdaptor = new ClassLoaderWeavingAdaptor();
                    adaptor = new ExplicitlyInitializedClassLoaderWeavingAdaptor(weavingAdaptor);
                    weavingAdaptors.put(adaptorKey, adaptor);
                }
            }
            return adaptor.getWeavingAdaptor(loader, weavingContext);
        }
    }

    static class ExplicitlyInitializedClassLoaderWeavingAdaptor {
        private final ClassLoaderWeavingAdaptor weavingAdaptor;
        private boolean isInitialized;

        public ExplicitlyInitializedClassLoaderWeavingAdaptor(ClassLoaderWeavingAdaptor weavingAdaptor) {
            this.weavingAdaptor = weavingAdaptor;
            this.isInitialized = false;
        }

        private void initialize(ClassLoader loader, IWeavingContext weavingContext) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                this.weavingAdaptor.initialize(loader, weavingContext);
            }
        }

        public ClassLoaderWeavingAdaptor getWeavingAdaptor(ClassLoader loader, IWeavingContext weavingContext) {
            this.initialize(loader, weavingContext);
            return this.weavingAdaptor;
        }
    }
}

