/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools.cache;

import org.aspectj.weaver.tools.cache.CachedClassReference;

public class CachedClassEntry {
    private final CachedClassReference ref;
    private final byte[] bytes;
    private final EntryType type;

    public CachedClassEntry(CachedClassReference ref, byte[] bytes, EntryType type) {
        this.bytes = bytes;
        this.ref = ref;
        this.type = type;
    }

    public String getClassName() {
        return this.ref.getClassName();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getKey() {
        return this.ref.getKey();
    }

    public boolean isGenerated() {
        return this.type == EntryType.GENERATED;
    }

    public boolean isWeaved() {
        return this.type == EntryType.WEAVED;
    }

    public boolean isIgnored() {
        return this.type == EntryType.IGNORED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryType {
        GENERATED,
        WEAVED,
        IGNORED;

    }
}

