/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.AbstractAssertWithOriginWithChanges;
import org.assertj.db.api.ChangeColumnAssert;
import org.assertj.db.api.ChangeRowAssert;
import org.assertj.db.api.ChangesAssert;
import org.assertj.db.api.assertions.AssertOnChangeType;
import org.assertj.db.api.assertions.AssertOnDataType;
import org.assertj.db.api.assertions.AssertOnModifiedColumns;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnPrimaryKey;
import org.assertj.db.api.assertions.impl.AssertionsOnChangeType;
import org.assertj.db.api.assertions.impl.AssertionsOnDataType;
import org.assertj.db.api.assertions.impl.AssertionsOnModifiedColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnPrimaryKey;
import org.assertj.db.navigation.PositionWithColumnsChange;
import org.assertj.db.navigation.PositionWithPoints;
import org.assertj.db.navigation.element.ChangeElement;
import org.assertj.db.navigation.origin.OriginWithColumnsAndRowsFromChange;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.DataType;
import org.assertj.db.type.Row;
import org.assertj.db.util.Descriptions;

public class ChangeAssert
extends AbstractAssertWithOriginWithChanges<ChangeAssert, ChangesAssert>
implements ChangeElement,
OriginWithColumnsAndRowsFromChange<ChangesAssert, ChangeAssert, ChangeColumnAssert, ChangeRowAssert>,
AssertOnDataType<ChangeAssert>,
AssertOnPrimaryKey<ChangeAssert>,
AssertOnChangeType<ChangeAssert>,
AssertOnModifiedColumns<ChangeAssert>,
AssertOnNumberOfColumns<ChangeAssert> {
    private final Change change;
    private final PositionWithPoints<ChangeAssert, ChangeRowAssert, Row> rowPosition;
    private final PositionWithColumnsChange<ChangeAssert, ChangeColumnAssert> columnPosition;

    public ChangeAssert(ChangesAssert origin, Change change) {
        super(ChangeAssert.class, origin);
        this.change = change;
        this.rowPosition = new PositionWithPoints<ChangeAssert, ChangeRowAssert, Row>(this, ChangeRowAssert.class, Row.class, change.getRowAtStartPoint(), change.getRowAtEndPoint()){

            @Override
            protected String getDescriptionAtStartPoint() {
                return Descriptions.getRowAtStartPointDescription(ChangeAssert.this.info);
            }

            @Override
            protected String getDescriptionAtEndPoint() {
                return Descriptions.getRowAtEndPointDescription(ChangeAssert.this.info);
            }
        };
        this.columnPosition = new PositionWithColumnsChange<ChangeAssert, ChangeColumnAssert>(this, ChangeColumnAssert.class){

            @Override
            protected String getDescription(int index, String columnName) {
                return Descriptions.getColumnDescription(ChangeAssert.this.info, index, columnName);
            }
        };
    }

    @Override
    public ChangeRowAssert rowAtStartPoint() {
        return this.rowPosition.getInstanceAtStartPoint();
    }

    @Override
    public ChangeRowAssert rowAtEndPoint() {
        return this.rowPosition.getInstanceAtEndPoint();
    }

    @Override
    public ChangeColumnAssert column() {
        return this.columnPosition.getChangeColumnInstance(this.change);
    }

    @Override
    public ChangeColumnAssert column(int index) {
        return this.columnPosition.getChangeColumnInstance(this.change, index);
    }

    @Override
    public ChangeColumnAssert column(String columnName) {
        return this.columnPosition.getChangeColumnInstance(this.change, columnName, this.change.getColumnLetterCase());
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes() {
        return this.columnPosition.getModifiedChangeColumnInstance(this.change);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes(int index) {
        return this.columnPosition.getModifiedChangeColumnInstance(this.change, index);
    }

    @Override
    public ChangeColumnAssert columnAmongTheModifiedOnes(String columnName) {
        return this.columnPosition.getModifiedChangeColumnInstance(this.change, columnName, this.change.getColumnLetterCase());
    }

    @Override
    public ChangeAssert isOnDataType(DataType expected) {
        return (ChangeAssert)AssertionsOnDataType.isOnDataType((AbstractAssert)this.myself, this.info, this.change, expected);
    }

    @Override
    public ChangeAssert isOnTable() {
        return (ChangeAssert)AssertionsOnDataType.isOnTable((AbstractAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isOnRequest() {
        return (ChangeAssert)AssertionsOnDataType.isOnRequest((AbstractAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isOnTable(String name) {
        return (ChangeAssert)AssertionsOnDataType.isOnTable((AbstractAssert)this.myself, this.info, this.change, this.change.getTableLetterCase(), name);
    }

    @Override
    public ChangeAssert hasPksNames(String ... names) {
        return (ChangeAssert)AssertionsOnPrimaryKey.hasPksNames((AbstractAssert)this.myself, this.info, this.change, this.change.getPrimaryKeyLetterCase(), names);
    }

    @Override
    public ChangeAssert hasPksValues(Object ... values) {
        return (ChangeAssert)AssertionsOnPrimaryKey.hasPksValues((AbstractAssert)this.myself, this.info, this.change, values);
    }

    @Override
    public ChangeAssert isOfType(ChangeType expected) {
        return (ChangeAssert)AssertionsOnChangeType.isOfType((AbstractAssert)this.myself, this.info, this.change, expected);
    }

    @Override
    public ChangeAssert isCreation() {
        return (ChangeAssert)AssertionsOnChangeType.isCreation((AbstractAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isModification() {
        return (ChangeAssert)AssertionsOnChangeType.isModification((AbstractAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert isDeletion() {
        return (ChangeAssert)AssertionsOnChangeType.isDeletion((AbstractAssert)this.myself, this.info, this.change);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumns(int number) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasNumberOfModifiedColumns((AbstractAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsGreaterThan(int number) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsGreaterThan((AbstractAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsLessThan(int number) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsLessThan((AbstractAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsGreaterThanOrEqualTo(int number) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasNumberOfModifiedColumnsLessThanOrEqualTo(int number) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasNumberOfModifiedColumnsLessThanOrEqualTo((AbstractAssert)this.myself, this.info, this.change, number);
    }

    @Override
    public ChangeAssert hasModifiedColumns(Integer ... indexes) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasModifiedColumns((AbstractAssert)this.myself, this.info, this.change, indexes);
    }

    @Override
    public ChangeAssert hasModifiedColumns(String ... names) {
        return (ChangeAssert)AssertionsOnModifiedColumns.hasModifiedColumns((AbstractAssert)this.myself, this.info, this.change, this.change.getColumnLetterCase(), names);
    }

    @Override
    public ChangeAssert hasNumberOfColumns(int expected) {
        return (ChangeAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns((AbstractAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsGreaterThan(int expected) {
        return (ChangeAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThan((AbstractAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsLessThan(int expected) {
        return (ChangeAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThan((AbstractAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsGreaterThanOrEqualTo(int expected) {
        return (ChangeAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    @Override
    public ChangeAssert hasNumberOfColumnsLessThanOrEqualTo(int expected) {
        return (ChangeAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThanOrEqualTo((AbstractAssert)this.myself, this.info, this.change.getColumnsNameList().size(), expected);
    }

    public ChangesAssert returnToChanges() {
        return (ChangesAssert)this.returnToOrigin();
    }
}

