/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.error.ShouldBeModified;
import org.assertj.db.error.ShouldNotBeModified;
import org.assertj.db.type.Value;

public class AssertionsOnModifiedColumn {
    private static final Failures failures = Failures.instance();

    private AssertionsOnModifiedColumn() {
    }

    public static <A extends AbstractAssert<?>> A isModified(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint) {
        if (valueAtStartPoint.getValue() == null && valueAtEndPoint.getValue() == null || valueAtStartPoint.getValue() != null && valueAtStartPoint.getValue().equals(valueAtEndPoint.getValue())) {
            throw failures.failure((AssertionInfo)info, ShouldBeModified.shouldBeModified(valueAtStartPoint, valueAtEndPoint));
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A isNotModified(A assertion, WritableAssertionInfo info, Value valueAtStartPoint, Value valueAtEndPoint) {
        if (valueAtStartPoint.getValue() == null && valueAtEndPoint.getValue() != null || valueAtStartPoint.getValue() != null && !valueAtStartPoint.getValue().equals(valueAtEndPoint.getValue())) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeModified.shouldNotBeModified(valueAtStartPoint, valueAtEndPoint));
        }
        return assertion;
    }
}

