/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.navigation;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.global.AbstractElement;
import org.assertj.db.type.Change;
import org.assertj.db.type.ChangeType;
import org.assertj.db.type.Changes;
import org.assertj.db.type.Value;
import org.assertj.db.util.Values;

public abstract class PositionWithChanges<E extends AbstractElement, N extends AbstractElement> {
    private final E myself;
    private final Map<ChangeType, Map<String, Integer>> indexNextChangeMap = new HashMap<ChangeType, Map<String, Integer>>();
    private final Map<ChangeType, Map<String, E>> changesAssertMap = new HashMap<ChangeType, Map<String, E>>();
    private final Map<Change, N> changeMap = new HashMap<Change, N>();
    private final Class<E> actualElementClass;
    private final Class<N> nextElementClass;

    public PositionWithChanges(E myself, Class<E> actualElementClass, Class<N> nextElementClass) {
        this.myself = myself;
        this.actualElementClass = actualElementClass;
        this.nextElementClass = nextElementClass;
    }

    private E getFromCache(ChangeType changeType, String tableName) {
        Map<String, E> mapWithTableName = this.changesAssertMap.get((Object)changeType);
        if (mapWithTableName == null) {
            return null;
        }
        return (E)((AbstractElement)mapWithTableName.get(tableName));
    }

    private void setInCache(ChangeType changeType, String tableName, E changesInstance) {
        Map<String, E> mapWithTableName = this.changesAssertMap.get((Object)changeType);
        if (mapWithTableName == null) {
            mapWithTableName = new HashMap<String, E>();
            this.changesAssertMap.put(changeType, mapWithTableName);
        }
        mapWithTableName.put(tableName, changesInstance);
    }

    public E getChangesInstance(Changes changes, ChangeType changeType, String tableName) {
        Object instance = this.getFromCache(changeType, tableName);
        if (instance != null) {
            return instance;
        }
        Changes nextChanges = changes;
        if (changeType != null) {
            nextChanges = nextChanges.getChangesOfType(changeType);
        }
        if (tableName != null) {
            nextChanges = nextChanges.getChangesOfTable(tableName);
        }
        try {
            Constructor<E> constructor = this.actualElementClass.getDeclaredConstructor(this.myself.getClass(), Changes.class);
            instance = (AbstractElement)constructor.newInstance(this.myself, nextChanges);
            ((AbstractElement)instance).as(this.getChangesDescription(changeType, tableName), new Object[0]);
            this.setInCache(changeType, tableName, instance);
            return instance;
        }
        catch (Exception e) {
            throw new AssertJDBException(String.format("There is an exception '" + e.getMessage() + "'%n\t in the instantiation of the element " + this.actualElementClass.getName() + "%n\t on " + Changes.class + " with " + this.myself.getClass() + ".%n " + "It is normally impossible.%n That means there is a big mistake in the development of AssertJDB.%n " + "Please write an issue for that if you meet this problem.", new Object[0]), new Object[0]);
        }
    }

    private Change getChange(Changes changes, int index, ChangeType changeType, String tableName) {
        if (changeType != null) {
            changes = changes.getChangesOfType(changeType);
        }
        if (tableName != null) {
            changes = changes.getChangesOfTable(tableName);
        }
        List<Change> changesList = changes.getChangesList();
        int size = changesList.size();
        if (index < 0 || index >= size) {
            throw new AssertJDBException("Index %s out of the limits [0, %s[", index, size);
        }
        Change change = changesList.get(index);
        this.setIndexNextChange(changeType, tableName, index + 1);
        return change;
    }

    public N getChangeInstance(Changes changes, ChangeType changeType, String tableName) {
        return this.getChangeInstance(changes, changeType, tableName, this.getIndexNextChange(changeType, tableName));
    }

    public N getChangeInstance(Changes changes, ChangeType changeType, String tableName, int index) {
        Change change = this.getChange(changes, index, changeType, tableName);
        AbstractElement instance = (AbstractElement)this.changeMap.get(change);
        if (instance != null) {
            return (N)instance;
        }
        try {
            Constructor<N> constructor = this.nextElementClass.getDeclaredConstructor(this.myself.getClass(), Change.class);
            instance = (AbstractElement)constructor.newInstance(this.myself, change);
            instance.as(this.getChangeDescription(changes, change, index, changeType, tableName), new Object[0]);
            this.changeMap.put(change, instance);
            this.setIndexNextChange(changeType, tableName, index + 1);
            return (N)instance;
        }
        catch (Exception e) {
            throw new AssertJDBException(String.format("There is an exception '" + e.getMessage() + "'%n\t in the instantiation of the element " + this.nextElementClass.getName() + "%n\t on " + Change.class + " with " + this.myself.getClass() + ".%n " + "It is normally impossible.%n That means there is a big mistake in the development of AssertJDB.%n " + "Please write an issue for that if you meet this problem.", new Object[0]), new Object[0]);
        }
    }

    public N getChangeInstanceWithPK(Changes changes, String tableName, Object ... pksValues) {
        Changes changesOfTable = changes.getChangesOfTable(tableName);
        List<Change> changesList = changesOfTable.getChangesList();
        int index = 0;
        for (Change change : changesList) {
            List<Value> pksValueList = change.getPksValueList();
            Value[] values = pksValueList.toArray(new Value[pksValueList.size()]);
            boolean equal = false;
            if (pksValues.length == values.length) {
                equal = true;
                for (int i = 0; i < pksValues.length; ++i) {
                    if (Values.areEqual(values[i], pksValues[i])) continue;
                    equal = false;
                }
            }
            if (equal) {
                return this.getChangeInstance(changesOfTable, null, tableName, index);
            }
            ++index;
        }
        throw new AssertJDBException("No change found for table " + tableName + " and primary keys " + Arrays.asList(pksValues), new Object[0]);
    }

    private Integer getIndexNextChange(ChangeType changeType, String tableName) {
        Integer index;
        Map<String, Integer> map = this.indexNextChangeMap.get((Object)changeType);
        if (map != null && (index = map.get(tableName)) != null) {
            return index;
        }
        return 0;
    }

    private void setIndexNextChange(ChangeType changeType, String tableName, int index) {
        Map<String, Integer> map = this.indexNextChangeMap.get((Object)changeType);
        if (map == null) {
            map = new HashMap<String, Integer>();
            this.indexNextChangeMap.put(changeType, map);
        }
        map.put(tableName, index);
    }

    protected abstract String getChangesDescription(ChangeType var1, String var2);

    protected abstract String getChangeDescription(Changes var1, Change var2, int var3, ChangeType var4, String var5);
}

