/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.util;

import java.util.Comparator;
import java.util.List;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;

public enum RowComparator implements Comparator<Row>
{
    INSTANCE;


    private static int compare(Value[] values1, Value[] values2) {
        if (values1.length == values2.length) {
            for (int index = 0; index < values1.length; ++index) {
                Comparable comparable1;
                int compare;
                Value value1 = values1[index];
                Value value2 = values2[index];
                Object object1 = value1.getValue();
                Object object2 = value2.getValue();
                if (object1 == null && object2 != null) {
                    return 1;
                }
                if (object1 != null && object2 == null) {
                    return -1;
                }
                if (!(object1 instanceof Comparable) || !(object2 instanceof Comparable) || (compare = (comparable1 = (Comparable)Comparable.class.cast(object1)).compareTo(object2)) == 0) continue;
                return compare;
            }
        }
        return 0;
    }

    @Override
    public int compare(Row row1, Row row2) {
        Value[] pksValues2;
        Value[] pksValues1 = row1.getPksValues();
        int compare = RowComparator.compare(pksValues1, pksValues2 = row2.getPksValues());
        if (compare != 0) {
            return compare;
        }
        List<Value> valuesList1 = row1.getValuesList();
        List<Value> valuesList2 = row2.getValuesList();
        Value[] values1 = valuesList1.toArray(new Value[valuesList1.size()]);
        Value[] values2 = valuesList2.toArray(new Value[valuesList2.size()]);
        return RowComparator.compare(values1, values2);
    }
}

