/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncHttpClientConfigHelper {
    private static volatile Config config;

    public static Config getAsyncHttpClientConfig() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public static void reloadProperties() {
        if (config != null) {
            config.reload();
        }
    }

    public static class Config {
        public static final String DEFAULT_AHC_PROPERTIES = "ahc-default.properties";
        public static final String CUSTOM_AHC_PROPERTIES = "ahc.properties";
        private final ConcurrentHashMap<String, String> propsCache = new ConcurrentHashMap();
        private final Properties defaultProperties = this.parsePropertiesFile("ahc-default.properties");
        private volatile Properties customProperties = this.parsePropertiesFile("ahc.properties");

        public void reload() {
            this.customProperties = this.parsePropertiesFile(CUSTOM_AHC_PROPERTIES);
            this.propsCache.clear();
        }

        private Properties parsePropertiesFile(String file) {
            Properties props = new Properties();
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);){
                if (is != null) {
                    props.load(is);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't parse file", e);
            }
            return props;
        }

        public String getString(String key) {
            return this.propsCache.computeIfAbsent(key, k -> {
                String value = System.getProperty(k);
                if (value == null) {
                    value = this.customProperties.getProperty((String)k);
                }
                if (value == null) {
                    value = this.defaultProperties.getProperty((String)k);
                }
                return value;
            });
        }

        public String[] getStringArray(String key) {
            String s = this.getString(key);
            String[] rawArray = s.split(",");
            String[] array = new String[rawArray.length];
            for (int i = 0; i < rawArray.length; ++i) {
                array[i] = rawArray[i].trim();
            }
            return array;
        }

        public int getInt(String key) {
            return Integer.parseInt(this.getString(key));
        }

        public long getLong(String key) {
            return Long.parseLong(this.getString(key));
        }

        public Integer getInteger(String key) {
            String s = this.getString(key);
            return s != null ? Integer.valueOf(s) : null;
        }

        public boolean getBoolean(String key) {
            return Boolean.parseBoolean(this.getString(key));
        }
    }
}

