/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.util.Locale;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.NettyResponseStatus;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.handler.Protocol;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.ws.NettyWebSocket;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.asynchttpclient.ws.WebSocketUtils;

public final class WebSocketProtocol
extends Protocol {
    public WebSocketProtocol(ChannelManager channelManager, AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        super(channelManager, config, requestSender);
    }

    private void invokeOnSucces(Channel channel, WebSocketUpgradeHandler h) {
        if (!h.touchSuccess()) {
            try {
                h.onSuccess(new NettyWebSocket(channel, this.config));
            }
            catch (Exception ex) {
                this.logger.warn("onSuccess unexpected exception", (Throwable)ex);
            }
        }
    }

    @Override
    public void handle(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        if (e instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)e;
            Channels.setAttribute(channel, new UpgradeCallback(future, channel, response));
        } else if (e instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)e;
            WebSocketUpgradeHandler handler = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(future.getAsyncHandler());
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(handler.onCompleted());
            this.invokeOnSucces(channel, handler);
            if (webSocket != null) {
                if (frame instanceof CloseWebSocketFrame) {
                    Channels.setDiscard(channel);
                    CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)CloseWebSocketFrame.class.cast(frame);
                    webSocket.onClose(closeFrame.statusCode(), closeFrame.reasonText());
                } else {
                    ByteBuf buf = frame.content();
                    if (buf != null && buf.readableBytes() > 0) {
                        HttpResponseBodyPart part = this.config.getResponseBodyPartFactory().newResponseBodyPart(buf, frame.isFinalFragment());
                        handler.onBodyPartReceived(part);
                        if (frame instanceof BinaryWebSocketFrame) {
                            webSocket.onBinaryFragment(part);
                        } else if (frame instanceof TextWebSocketFrame) {
                            webSocket.onTextFragment(part);
                        } else if (frame instanceof PingWebSocketFrame) {
                            webSocket.onPing(part);
                        } else if (frame instanceof PongWebSocketFrame) {
                            webSocket.onPong(part);
                        }
                    }
                }
            } else {
                this.logger.debug("UpgradeHandler returned a null NettyWebSocket ");
            }
        } else {
            this.logger.error("Invalid message {}", e);
        }
    }

    @Override
    public void onError(NettyResponseFuture<?> future, Throwable e) {
        this.logger.warn("onError {}", e);
        try {
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)future.getAsyncHandler();
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
            if (webSocket != null) {
                webSocket.onError(e.getCause());
                webSocket.close();
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    @Override
    public void onClose(NettyResponseFuture<?> future) {
        this.logger.trace("onClose");
        try {
            WebSocketUpgradeHandler h = (WebSocketUpgradeHandler)future.getAsyncHandler();
            NettyWebSocket webSocket = (NettyWebSocket)NettyWebSocket.class.cast(h.onCompleted());
            this.logger.trace("Connection was closed abnormally (that is, with no close frame being sent).");
            if (webSocket != null) {
                webSocket.close(1006, "Connection was closed abnormally (that is, with no close frame being sent).");
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    private class UpgradeCallback
    extends Callback {
        private final Channel channel;
        private final HttpResponse response;

        public UpgradeCallback(NettyResponseFuture<?> future, Channel channel, HttpResponse response) {
            super(future);
            this.channel = channel;
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call() throws Exception {
            boolean headerOK;
            boolean statusReceived;
            Realm realm;
            WebSocketUpgradeHandler handler = (WebSocketUpgradeHandler)WebSocketUpgradeHandler.class.cast(this.future.getAsyncHandler());
            Request request = this.future.getCurrentRequest();
            NettyResponseStatus status = new NettyResponseStatus(this.future.getUri(), WebSocketProtocol.this.config, this.response, this.channel);
            HttpResponseHeaders responseHeaders = new HttpResponseHeaders(this.response.headers());
            Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : WebSocketProtocol.this.config.getRealm();
            if (WebSocketProtocol.this.exitAfterProcessingFilters(this.channel, this.future, handler, status, responseHeaders)) {
                return;
            }
            if (Protocol.REDIRECT_STATUSES.contains(((HttpResponseStatus)status).getStatusCode()) && WebSocketProtocol.this.exitAfterHandlingRedirect(this.channel, this.future, this.response, request, this.response.getStatus().code(), realm)) {
                return;
            }
            boolean validStatus = this.response.getStatus().equals((Object)io.netty.handler.codec.http.HttpResponseStatus.SWITCHING_PROTOCOLS);
            boolean validUpgrade = this.response.headers().get("Upgrade") != null;
            String connection = this.response.headers().get("Connection");
            if (connection == null) {
                connection = this.response.headers().get("Connection".toLowerCase(Locale.ENGLISH));
            }
            boolean validConnection = "Upgrade".equalsIgnoreCase(connection);
            boolean bl = statusReceived = handler.onStatusReceived(status) == AsyncHandler.State.UPGRADE;
            if (!statusReceived) {
                try {
                    handler.onCompleted();
                }
                finally {
                    this.future.done();
                }
                return;
            }
            boolean bl2 = headerOK = handler.onHeadersReceived(responseHeaders) == AsyncHandler.State.CONTINUE;
            if (!(headerOK && validStatus && validUpgrade && validConnection)) {
                WebSocketProtocol.this.requestSender.abort(this.channel, this.future, new IOException("Invalid handshake response"));
                return;
            }
            String accept = this.response.headers().get("Sec-WebSocket-Accept");
            String key = WebSocketUtils.getAcceptKey(this.future.getNettyRequest().getHttpRequest().headers().get("Sec-WebSocket-Key"));
            if (accept == null || !accept.equals(key)) {
                WebSocketProtocol.this.requestSender.abort(this.channel, this.future, new IOException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, key)));
            }
            WebSocketProtocol.this.channelManager.upgradePipelineForWebSockets(this.channel.pipeline());
            WebSocketProtocol.this.invokeOnSucces(this.channel, handler);
            this.future.done();
            Channels.setAttribute(this.channel, this.future);
        }
    }
}

