/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.asynchttpclient.request.body.generator.SimpleFeedableBodyGenerator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveStreamsBodyGenerator
implements FeedableBodyGenerator {
    private static final ByteBuffer EMPTY = ByteBuffer.wrap("".getBytes());
    private final Publisher<ByteBuffer> publisher;
    private final FeedableBodyGenerator feedableBodyGenerator;
    private final AtomicReference<FeedableBodyGenerator.FeedListener> feedListener = new AtomicReference<Object>(null);

    public ReactiveStreamsBodyGenerator(Publisher<ByteBuffer> publisher) {
        this.publisher = publisher;
        this.feedableBodyGenerator = new SimpleFeedableBodyGenerator();
    }

    public Publisher<ByteBuffer> getPublisher() {
        return this.publisher;
    }

    @Override
    public void feed(ByteBuffer buffer, boolean isLast) {
        this.feedableBodyGenerator.feed(buffer, isLast);
    }

    @Override
    public void setListener(FeedableBodyGenerator.FeedListener listener) {
        this.feedListener.set(listener);
        this.feedableBodyGenerator.setListener(listener);
    }

    @Override
    public Body createBody() {
        return new StreamedBody(this.publisher, this.feedableBodyGenerator);
    }

    private class SimpleSubscriber
    implements Subscriber<ByteBuffer> {
        private final Logger LOGGER = LoggerFactory.getLogger(SimpleSubscriber.class);
        private final FeedableBodyGenerator feeder;
        private volatile Subscription subscription;

        public SimpleSubscriber(FeedableBodyGenerator feeder) {
            this.feeder = feeder;
        }

        public void onSubscribe(Subscription s) {
            if (s == null) {
                throw null;
            }
            if (this.subscription != null) {
                s.cancel();
            } else {
                this.subscription = s;
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        public void onNext(ByteBuffer t) {
            if (t == null) {
                throw null;
            }
            try {
                this.feeder.feed(t, false);
            }
            catch (Exception e) {
                this.LOGGER.error("Exception occurred while processing element in stream.", (Throwable)e);
                this.subscription.cancel();
            }
        }

        public void onError(Throwable t) {
            if (t == null) {
                throw null;
            }
            this.LOGGER.debug("Error occurred while consuming body stream.", t);
            FeedableBodyGenerator.FeedListener listener = (FeedableBodyGenerator.FeedListener)ReactiveStreamsBodyGenerator.this.feedListener.get();
            if (listener != null) {
                listener.onError(t);
            }
        }

        public void onComplete() {
            try {
                this.feeder.feed(EMPTY, true);
            }
            catch (Exception e) {
                this.LOGGER.info("Ignoring exception occurred while completing stream processing.", (Throwable)e);
                this.subscription.cancel();
            }
        }
    }

    private class StreamedBody
    implements Body {
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private final SimpleSubscriber subscriber;
        private final Body body;

        public StreamedBody(Publisher<ByteBuffer> publisher, FeedableBodyGenerator bodyGenerator) {
            this.body = bodyGenerator.createBody();
            this.subscriber = new SimpleSubscriber(bodyGenerator);
        }

        @Override
        public void close() throws IOException {
            this.body.close();
        }

        @Override
        public long getContentLength() {
            return this.body.getContentLength();
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            if (this.initialized.compareAndSet(false, true)) {
                ReactiveStreamsBodyGenerator.this.publisher.subscribe((Subscriber)this.subscriber);
            }
            return this.body.transferTo(target);
        }
    }
}

