/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;

public final class SimpleFeedableBodyGenerator
implements FeedableBodyGenerator,
BodyGenerator {
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private FeedableBodyGenerator.FeedListener listener;

    @Override
    public Body createBody() {
        return new PushBody();
    }

    @Override
    public void feed(ByteBuffer buffer, boolean isLast) {
        this.queue.offer(new BodyPart(buffer, isLast));
        if (this.listener != null) {
            this.listener.onContentAdded();
        }
    }

    @Override
    public void setListener(FeedableBodyGenerator.FeedListener listener) {
        this.listener = listener;
    }

    private void move(ByteBuf target, ByteBuffer source) {
        int size = Math.min(target.writableBytes(), source.remaining());
        if (size > 0) {
            ByteBuffer slice = source.slice();
            slice.limit(size);
            target.writeBytes(slice);
            source.position(source.position() + size);
        }
    }

    private final class BodyPart {
        private final boolean isLast;
        private final ByteBuffer buffer;

        public BodyPart(ByteBuffer buffer, boolean isLast) {
            this.buffer = buffer;
            this.isLast = isLast;
        }
    }

    public final class PushBody
    implements Body {
        private Body.BodyState state = Body.BodyState.CONTINUE;

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            switch (this.state) {
                case CONTINUE: {
                    return this.readNextPart(target);
                }
                case STOP: {
                    return Body.BodyState.STOP;
                }
            }
            throw new IllegalStateException("Illegal process state.");
        }

        private Body.BodyState readNextPart(ByteBuf target) throws IOException {
            Body.BodyState res = Body.BodyState.SUSPEND;
            while (target.isWritable() && this.state != Body.BodyState.STOP) {
                BodyPart nextPart = (BodyPart)SimpleFeedableBodyGenerator.this.queue.peek();
                if (nextPart == null) {
                    return res;
                }
                if (!nextPart.buffer.hasRemaining() && !nextPart.isLast) {
                    SimpleFeedableBodyGenerator.this.queue.remove();
                    continue;
                }
                res = Body.BodyState.CONTINUE;
                this.readBodyPart(target, nextPart);
            }
            return res;
        }

        private void readBodyPart(ByteBuf target, BodyPart part) {
            SimpleFeedableBodyGenerator.this.move(target, part.buffer);
            if (!part.buffer.hasRemaining()) {
                if (part.isLast) {
                    this.state = Body.BodyState.STOP;
                }
                SimpleFeedableBodyGenerator.this.queue.remove();
            }
        }

        @Override
        public void close() {
        }
    }
}

