/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

public final class Base64 {
    private static final char[] lookup;
    private static final byte[] reverseLookup;

    private Base64() {
    }

    public static String encode(byte[] bytes) {
        int chunk;
        StringBuilder buf = new StringBuilder((bytes.length + 2) / 3 * 4);
        int i = 0;
        int end = bytes.length - 2;
        while (i < end) {
            chunk = (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
            buf.append(lookup[chunk >> 18]);
            buf.append(lookup[chunk >> 12 & 0x3F]);
            buf.append(lookup[chunk >> 6 & 0x3F]);
            buf.append(lookup[chunk & 0x3F]);
        }
        int len = bytes.length;
        if (i < len) {
            chunk = (bytes[i++] & 0xFF) << 16;
            buf.append(lookup[chunk >> 18]);
            if (i < len) {
                buf.append(lookup[(chunk |= (bytes[i] & 0xFF) << 8) >> 12 & 0x3F]);
                buf.append(lookup[chunk >> 6 & 0x3F]);
            } else {
                buf.append(lookup[chunk >> 12 & 0x3F]);
                buf.append('=');
            }
            buf.append('=');
        }
        return buf.toString();
    }

    public static byte[] decode(String encoded) {
        int padding = 0;
        int i = encoded.length() - 1;
        while (encoded.charAt(i) == '=') {
            ++padding;
            --i;
        }
        int length = encoded.length() * 6 / 8 - padding;
        byte[] bytes = new byte[length];
        int index = 0;
        int n = encoded.length();
        for (int i2 = 0; i2 < n; i2 += 4) {
            int word = reverseLookup[encoded.charAt(i2)] << 18;
            word += reverseLookup[encoded.charAt(i2 + 1)] << 12;
            word += reverseLookup[encoded.charAt(i2 + 2)] << 6;
            word += reverseLookup[encoded.charAt(i2 + 3)];
            for (int j = 0; j < 3 && index + j < length; ++j) {
                bytes[index + j] = (byte)(word >> 8 * (2 - j));
            }
            index += 3;
        }
        return bytes;
    }

    static {
        int i;
        lookup = new char[64];
        reverseLookup = new byte[256];
        for (i = 0; i < 26; ++i) {
            Base64.lookup[i] = (char)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i < 52) {
            Base64.lookup[i] = (char)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i < 62) {
            Base64.lookup[i] = (char)(48 + j);
            ++i;
            ++j;
        }
        Base64.lookup[62] = 43;
        Base64.lookup[63] = 47;
        for (i = 0; i < 256; ++i) {
            Base64.reverseLookup[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64.reverseLookup[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            Base64.reverseLookup[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            Base64.reverseLookup[i] = (byte)(i - 48 + 52);
        }
        Base64.reverseLookup[43] = 62;
        Base64.reverseLookup[47] = 63;
        Base64.reverseLookup[61] = 0;
    }
}

