/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.SimpleChannelFutureListener;
import org.asynchttpclient.netty.channel.NettyConnectListener;

public class NettyChannelConnector {
    private final AsyncHandlerExtensions asyncHandlerExtensions;
    private final InetSocketAddress localAddress;
    private final List<InetSocketAddress> remoteAddresses;
    private volatile int i = 0;

    public NettyChannelConnector(InetAddress localAddress, List<InetSocketAddress> remoteAddresses, AsyncHandler<?> asyncHandler) {
        this.localAddress = localAddress != null ? new InetSocketAddress(localAddress, 0) : null;
        this.remoteAddresses = remoteAddresses;
        this.asyncHandlerExtensions = AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler);
    }

    private boolean pickNextRemoteAddress() {
        ++this.i;
        return this.i < this.remoteAddresses.size();
    }

    public void connect(final Bootstrap bootstrap, final NettyConnectListener<?> connectListener) {
        final InetSocketAddress remoteAddress = this.remoteAddresses.get(this.i);
        if (this.asyncHandlerExtensions != null) {
            this.asyncHandlerExtensions.onTcpConnectAttempt(remoteAddress);
        }
        final ChannelFuture future = this.localAddress != null ? bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)this.localAddress) : bootstrap.connect((SocketAddress)remoteAddress);
        future.addListener((GenericFutureListener)new SimpleChannelFutureListener(){

            @Override
            public void onSuccess(Channel channel) throws Exception {
                if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                    NettyChannelConnector.this.asyncHandlerExtensions.onTcpConnectSuccess(remoteAddress, future.channel());
                }
                connectListener.onSuccess(channel);
            }

            @Override
            public void onFailure(Channel channel, Throwable t) throws Exception {
                boolean retry;
                if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                    NettyChannelConnector.this.asyncHandlerExtensions.onTcpConnectFailure(remoteAddress, t);
                }
                if (retry = NettyChannelConnector.this.pickNextRemoteAddress()) {
                    NettyChannelConnector.this.connect(bootstrap, connectListener);
                } else {
                    connectListener.onFailure(channel, t);
                }
            }
        });
    }
}

