/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.resolver;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.asynchttpclient.resolver.NameResolver;

public enum JdkNameResolver implements NameResolver
{
    INSTANCE;


    @Override
    public Future<List<InetSocketAddress>> resolve(String name, int port) {
        Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        try {
            InetAddress[] resolved = InetAddress.getAllByName(name);
            ArrayList<InetSocketAddress> socketResolved = new ArrayList<InetSocketAddress>(resolved.length);
            for (InetAddress res : resolved) {
                socketResolved.add(new InetSocketAddress(res, port));
            }
            return promise.setSuccess(socketResolved);
        }
        catch (UnknownHostException e) {
            return promise.setFailure((Throwable)e);
        }
    }
}

