/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler.intercept;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.handler.intercept.ConnectSuccessInterceptor;
import org.asynchttpclient.netty.handler.intercept.Continue100Interceptor;
import org.asynchttpclient.netty.handler.intercept.ProxyUnauthorized407Interceptor;
import org.asynchttpclient.netty.handler.intercept.Redirect30xInterceptor;
import org.asynchttpclient.netty.handler.intercept.ResponseFiltersInterceptor;
import org.asynchttpclient.netty.handler.intercept.Unauthorized401Interceptor;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.util.HttpConstants;

public class Interceptors {
    private final AsyncHttpClientConfig config;
    private final Unauthorized401Interceptor unauthorized401Interceptor;
    private final ProxyUnauthorized407Interceptor proxyUnauthorized407Interceptor;
    private final Continue100Interceptor continue100Interceptor;
    private final Redirect30xInterceptor redirect30xInterceptor;
    private final ConnectSuccessInterceptor connectSuccessInterceptor;
    private final ResponseFiltersInterceptor responseFiltersInterceptor;
    private final boolean hasResponseFilters;

    public Interceptors(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        this.config = config;
        this.unauthorized401Interceptor = new Unauthorized401Interceptor(channelManager, requestSender);
        this.proxyUnauthorized407Interceptor = new ProxyUnauthorized407Interceptor(channelManager, requestSender);
        this.continue100Interceptor = new Continue100Interceptor(requestSender);
        this.redirect30xInterceptor = new Redirect30xInterceptor(channelManager, config, requestSender);
        this.connectSuccessInterceptor = new ConnectSuccessInterceptor(channelManager, requestSender);
        this.responseFiltersInterceptor = new ResponseFiltersInterceptor(config, requestSender);
        this.hasResponseFilters = !config.getResponseFilters().isEmpty();
    }

    public boolean intercept(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponse response, HttpResponseStatus status, HttpResponseHeaders responseHeaders) throws Exception {
        Realm realm;
        HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
        ProxyServer proxyServer = future.getProxyServer();
        int statusCode = response.getStatus().code();
        Request request = future.getCurrentRequest();
        Realm realm2 = realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        if (this.hasResponseFilters && this.responseFiltersInterceptor.exitAfterProcessingFilters(channel, future, handler, status, responseHeaders)) {
            return true;
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.UNAUTHORIZED_401) {
            return this.unauthorized401Interceptor.exitAfterHandling401(channel, future, response, request, statusCode, realm, proxyServer, httpRequest);
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.PROXY_AUTHENTICATION_REQUIRED_407) {
            return this.proxyUnauthorized407Interceptor.exitAfterHandling407(channel, future, response, request, statusCode, proxyServer, httpRequest);
        }
        if (statusCode == HttpConstants.ResponseStatusCodes.CONTINUE_100) {
            return this.continue100Interceptor.exitAfterHandling100(channel, future, statusCode);
        }
        if (Redirect30xInterceptor.REDIRECT_STATUSES.contains(statusCode)) {
            return this.redirect30xInterceptor.exitAfterHandlingRedirect(channel, future, response, request, statusCode, realm);
        }
        if (httpRequest.getMethod() == HttpMethod.CONNECT && statusCode == HttpConstants.ResponseStatusCodes.OK_200) {
            return this.connectSuccessInterceptor.exitAfterHandlingConnect(channel, future, request, proxyServer, statusCode, httpRequest);
        }
        return false;
    }
}

