/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.exception.ChannelClosedException;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.DiscardEvent;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import org.asynchttpclient.netty.handler.intercept.Interceptors;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncHttpClientHandler
extends ChannelInboundHandlerAdapter {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final AsyncHttpClientConfig config;
    protected final ChannelManager channelManager;
    protected final NettyRequestSender requestSender;
    protected final Interceptors interceptors;
    protected final boolean hasIOExceptionFilters;

    public AsyncHttpClientHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        this.config = config;
        this.channelManager = channelManager;
        this.requestSender = requestSender;
        this.interceptors = new Interceptors(config, channelManager, requestSender);
        this.hasIOExceptionFilters = !config.getIoExceptionFilters().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        Object attribute = Channels.getAttribute(channel);
        try {
            if (attribute instanceof Callback) {
                Callback ac = (Callback)attribute;
                if (msg instanceof LastHttpContent) {
                    ac.call();
                } else if (!(msg instanceof HttpContent)) {
                    this.logger.info("Received unexpected message while expecting a chunk: " + msg);
                    ac.call();
                    Channels.setDiscard(channel);
                }
            } else if (attribute instanceof NettyResponseFuture) {
                NettyResponseFuture future = (NettyResponseFuture)attribute;
                this.handleRead(channel, future, msg);
            } else if (attribute instanceof StreamedResponsePublisher) {
                StreamedResponsePublisher publisher = (StreamedResponsePublisher)((Object)attribute);
                if (msg instanceof HttpContent) {
                    ByteBuf content = ((HttpContent)msg).content();
                    if (content.readableBytes() > 0) {
                        HttpResponseBodyPart part = this.config.getResponseBodyPartFactory().newResponseBodyPart(content, false);
                        ctx.fireChannelRead((Object)part);
                    }
                    if (msg instanceof LastHttpContent) {
                        ctx.pipeline().remove((ChannelHandler)publisher);
                        ctx.read();
                        this.handleRead(channel, publisher.future(), msg);
                    }
                } else {
                    this.logger.info("Received unexpected message while expecting a chunk: " + msg);
                    ctx.pipeline().remove((ChannelHandler)publisher);
                    Channels.setDiscard(channel);
                }
            } else if (attribute != DiscardEvent.INSTANCE) {
                this.logger.debug("Orphan channel {} with attribute {} received message {}, closing", new Object[]{channel, attribute, msg});
                Channels.silentlyCloseChannel(channel);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.requestSender.isClosed()) {
            return;
        }
        Channel channel = ctx.channel();
        this.channelManager.removeAll(channel);
        try {
            super.channelInactive(ctx);
        }
        catch (Exception ex) {
            this.logger.trace("super.channelClosed", (Throwable)ex);
        }
        NettyResponseFuture<?> attribute = Channels.getAttribute(channel);
        this.logger.debug("Channel Closed: {} with attribute {}", (Object)channel, (Object)attribute);
        if (attribute instanceof StreamedResponsePublisher) {
            attribute = ((StreamedResponsePublisher)((Object)attribute)).future();
        }
        if (attribute instanceof Callback) {
            Callback callback = (Callback)((Object)attribute);
            Channels.setAttribute(channel, callback.future());
            callback.call();
        } else if (attribute instanceof NettyResponseFuture) {
            NettyResponseFuture future = (NettyResponseFuture)NettyResponseFuture.class.cast(attribute);
            future.touch();
            if (this.hasIOExceptionFilters && this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, ChannelClosedException.INSTANCE, channel)) {
                return;
            }
            this.handleChannelInactive(future);
            this.requestSender.handleUnexpectedClosedChannel(channel, future);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        Throwable cause = MiscUtils.getCause(e);
        if (cause instanceof PrematureChannelClosureException || cause instanceof ClosedChannelException) {
            return;
        }
        Channel channel = ctx.channel();
        NettyResponseFuture<?> future = null;
        this.logger.debug("Unexpected I/O exception on channel {}", (Object)channel, (Object)cause);
        try {
            NettyResponseFuture<?> attribute = Channels.getAttribute(channel);
            if (attribute instanceof StreamedResponsePublisher) {
                ctx.fireExceptionCaught(e);
                attribute = ((StreamedResponsePublisher)((Object)attribute)).future();
            }
            if (attribute instanceof NettyResponseFuture) {
                future = attribute;
                future.attachChannel(null, false);
                future.touch();
                if (cause instanceof IOException && this.hasIOExceptionFilters) {
                    if (!this.requestSender.applyIoExceptionFiltersAndReplayRequest(future, ChannelClosedException.INSTANCE, channel)) {
                        Channels.silentlyCloseChannel(channel);
                    }
                    return;
                }
                if (StackTraceInspector.recoverOnReadOrWriteException(cause)) {
                    this.logger.debug("Trying to recover from dead Channel: {}", (Object)channel);
                    future.pendingException = cause;
                    return;
                }
            } else if (attribute instanceof Callback) {
                future = ((Callback)Callback.class.cast(attribute)).future();
            }
        }
        catch (Throwable t) {
            cause = t;
        }
        if (future != null) {
            try {
                this.logger.debug("Was unable to recover Future: {}", (Object)future);
                this.requestSender.abort(channel, future, cause);
                this.handleException(future, e);
            }
            catch (Throwable t) {
                this.logger.error(t.getMessage(), t);
            }
        }
        this.channelManager.closeChannel(channel);
        Channels.silentlyCloseChannel(channel);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (!this.isHandledByReactiveStreams(ctx)) {
            ctx.read();
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    private boolean isHandledByReactiveStreams(ChannelHandlerContext ctx) {
        return Channels.getAttribute(ctx.channel()) instanceof StreamedResponsePublisher;
    }

    public abstract void handleRead(Channel var1, NettyResponseFuture<?> var2, Object var3) throws Exception;

    public abstract void handleException(NettyResponseFuture<?> var1, Throwable var2);

    public abstract void handleChannelInactive(NettyResponseFuture<?> var1);
}

