/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.util.HttpConstants;

public final class Dsl {
    public static AsyncHttpClient asyncHttpClient() {
        return new DefaultAsyncHttpClient();
    }

    public static AsyncHttpClient asyncHttpClient(DefaultAsyncHttpClientConfig.Builder configBuilder) {
        return new DefaultAsyncHttpClient(configBuilder.build());
    }

    public static AsyncHttpClient asyncHttpClient(AsyncHttpClientConfig config) {
        return new DefaultAsyncHttpClient(config);
    }

    public static RequestBuilder get(String url) {
        return Dsl.request(HttpConstants.Methods.GET, url);
    }

    public static RequestBuilder put(String url) {
        return Dsl.request(HttpConstants.Methods.PUT, url);
    }

    public static RequestBuilder post(String url) {
        return Dsl.request(HttpConstants.Methods.POST, url);
    }

    public static RequestBuilder delete(String url) {
        return Dsl.request(HttpConstants.Methods.DELETE, url);
    }

    public static RequestBuilder head(String url) {
        return Dsl.request(HttpConstants.Methods.HEAD, url);
    }

    public static RequestBuilder options(String url) {
        return Dsl.request(HttpConstants.Methods.OPTIONS, url);
    }

    public static RequestBuilder path(String url) {
        return Dsl.request(HttpConstants.Methods.PATCH, url);
    }

    public static RequestBuilder trace(String url) {
        return Dsl.request(HttpConstants.Methods.TRACE, url);
    }

    public static RequestBuilder request(String method, String url) {
        return (RequestBuilder)new RequestBuilder(method).setUrl(url);
    }

    public static ProxyServer.Builder proxyServer(String host, int port) {
        return new ProxyServer.Builder(host, port);
    }

    public static DefaultAsyncHttpClientConfig.Builder config() {
        return new DefaultAsyncHttpClientConfig.Builder();
    }

    public static Realm.Builder realm(Realm prototype) {
        return new Realm.Builder(prototype.getPrincipal(), prototype.getPassword()).setRealmName(prototype.getRealmName()).setAlgorithm(prototype.getAlgorithm()).setMethodName(prototype.getMethodName()).setNc(prototype.getNc()).setNonce(prototype.getNonce()).setCharset(prototype.getCharset()).setOpaque(prototype.getOpaque()).setQop(prototype.getQop()).setScheme(prototype.getScheme()).setUri(prototype.getUri()).setUsePreemptiveAuth(prototype.isUsePreemptiveAuth()).setNtlmDomain(prototype.getNtlmDomain()).setNtlmHost(prototype.getNtlmHost()).setUseAbsoluteURI(prototype.isUseAbsoluteURI()).setOmitQuery(prototype.isOmitQuery());
    }

    public static Realm.Builder realm(Realm.AuthScheme scheme, String principal, String password) {
        return new Realm.Builder(principal, password).setScheme(scheme);
    }

    public static Realm.Builder basicAuthRealm(String principal, String password) {
        return Dsl.realm(Realm.AuthScheme.BASIC, principal, password);
    }

    public static Realm.Builder digestAuthRealm(String principal, String password) {
        return Dsl.realm(Realm.AuthScheme.DIGEST, principal, password);
    }

    public static Realm.Builder ntlmAuthRealm(String principal, String password) {
        return Dsl.realm(Realm.AuthScheme.NTLM, principal, password);
    }

    private Dsl() {
    }
}

