/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.SimpleChannelFutureListener;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.NettyConnectListener;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.util.Assertions;

public class NettyChannelConnector {
    private final AsyncHandlerExtensions asyncHandlerExtensions;
    private final InetSocketAddress localAddress;
    private final List<InetSocketAddress> remoteAddresses;
    private final TimeoutsHolder timeoutsHolder;
    private final AtomicBoolean closed;
    private final boolean connectionTtlEnabled;
    private volatile int i = 0;

    public NettyChannelConnector(InetAddress localAddress, List<InetSocketAddress> remoteAddresses, AsyncHandler<?> asyncHandler, TimeoutsHolder timeoutsHolder, AtomicBoolean closed, AsyncHttpClientConfig config) {
        this.localAddress = localAddress != null ? new InetSocketAddress(localAddress, 0) : null;
        this.remoteAddresses = remoteAddresses;
        this.asyncHandlerExtensions = AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler);
        this.timeoutsHolder = Assertions.assertNotNull(timeoutsHolder, "timeoutsHolder");
        this.closed = closed;
        this.connectionTtlEnabled = config.getConnectionTtl() > 0;
    }

    private boolean pickNextRemoteAddress() {
        ++this.i;
        return this.i < this.remoteAddresses.size();
    }

    public void connect(Bootstrap bootstrap, NettyConnectListener<?> connectListener) {
        InetSocketAddress remoteAddress = this.remoteAddresses.get(this.i);
        if (this.asyncHandlerExtensions != null) {
            this.asyncHandlerExtensions.onTcpConnectAttempt(remoteAddress);
        }
        try {
            this.connect0(bootstrap, connectListener, remoteAddress);
        }
        catch (RejectedExecutionException e) {
            if (this.closed.get()) {
                connectListener.onFailure(null, e);
            }
            throw e;
        }
    }

    private void connect0(final Bootstrap bootstrap, final NettyConnectListener<?> connectListener, final InetSocketAddress remoteAddress) {
        final ChannelFuture future = bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)this.localAddress);
        future.addListener((GenericFutureListener)new SimpleChannelFutureListener(){

            @Override
            public void onSuccess(Channel channel) {
                if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                    NettyChannelConnector.this.asyncHandlerExtensions.onTcpConnectSuccess(remoteAddress, future.channel());
                }
                NettyChannelConnector.this.timeoutsHolder.initRemoteAddress(remoteAddress);
                if (NettyChannelConnector.this.connectionTtlEnabled) {
                    Channels.initChannelId(channel);
                }
                connectListener.onSuccess(channel);
            }

            @Override
            public void onFailure(Channel channel, Throwable t) {
                boolean retry;
                if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                    NettyChannelConnector.this.asyncHandlerExtensions.onTcpConnectFailure(remoteAddress, t);
                }
                if (retry = NettyChannelConnector.this.pickNextRemoteAddress()) {
                    NettyChannelConnector.this.connect(bootstrap, connectListener);
                } else {
                    connectListener.onFailure(channel, t);
                }
            }
        });
    }
}

