/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.future;

import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.asynchttpclient.util.Assertions;

final class RunnableExecutorPair {
    private static final Logger log = Logger.getLogger(RunnableExecutorPair.class.getPackage().getName());
    final Runnable runnable;
    final Executor executor;
    RunnableExecutorPair next;

    RunnableExecutorPair() {
        this.runnable = null;
        this.executor = null;
    }

    RunnableExecutorPair(Runnable runnable, Executor executor, RunnableExecutorPair next) {
        Assertions.assertNotNull(runnable, "runnable");
        this.runnable = runnable;
        this.executor = executor;
        this.next = next;
    }

    static void executeListener(Runnable runnable, Executor executor) {
        try {
            if (executor != null) {
                executor.execute(runnable);
            } else {
                runnable.run();
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, e);
        }
    }

    static RunnableExecutorPair reverseList(RunnableExecutorPair list) {
        RunnableExecutorPair prev = null;
        while (list != null) {
            RunnableExecutorPair next = list.next;
            list.next = prev;
            prev = list;
            list = next;
        }
        return prev;
    }
}

