/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.Param;
import org.asynchttpclient.request.body.multipart.PartBase;
import org.asynchttpclient.request.body.multipart.part.MultipartState;
import org.asynchttpclient.request.body.multipart.part.PartVisitor;
import org.asynchttpclient.util.MiscUtils;

public abstract class MultipartPart<T extends PartBase>
implements Closeable {
    static final byte QUOTE_BYTE = 34;
    private static final byte[] CRLF_BYTES = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] EXTRA_BYTES = "--".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_DISPOSITION_BYTES = "Content-Disposition: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] FORM_DATA_DISPOSITION_TYPE_BYTES = "form-data".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] NAME_BYTES = "; name=".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_TYPE_BYTES = "Content-Type: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CHARSET_BYTES = "; charset=".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_TRANSFER_ENCODING_BYTES = "Content-Transfer-Encoding: ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] HEADER_NAME_VALUE_SEPARATOR_BYTES = ": ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CONTENT_ID_BYTES = "Content-ID: ".getBytes(StandardCharsets.US_ASCII);
    protected final T part;
    protected final byte[] boundary;
    private final int preContentLength;
    private final int postContentLength;
    protected MultipartState state;
    boolean slowTarget;
    private ByteBuf preContentBuffer;
    private ByteBuf postContentBuffer;

    MultipartPart(T part, byte[] boundary) {
        this.part = part;
        this.boundary = boundary;
        this.preContentLength = this.computePreContentLength();
        this.postContentLength = this.computePostContentLength();
        this.state = MultipartState.PRE_CONTENT;
    }

    public long length() {
        return (long)(this.preContentLength + this.postContentLength) + this.getContentLength();
    }

    public MultipartState getState() {
        return this.state;
    }

    public boolean isTargetSlow() {
        return this.slowTarget;
    }

    public long transferTo(ByteBuf target) throws IOException {
        switch (this.state) {
            case DONE: {
                return 0L;
            }
            case PRE_CONTENT: {
                return this.transfer(this.lazyLoadPreContentBuffer(), target, MultipartState.CONTENT);
            }
            case CONTENT: {
                return this.transferContentTo(target);
            }
            case POST_CONTENT: {
                return this.transfer(this.lazyLoadPostContentBuffer(), target, MultipartState.DONE);
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    public long transferTo(WritableByteChannel target) throws IOException {
        this.slowTarget = false;
        switch (this.state) {
            case DONE: {
                return 0L;
            }
            case PRE_CONTENT: {
                return this.transfer(this.lazyLoadPreContentBuffer(), target, MultipartState.CONTENT);
            }
            case CONTENT: {
                return this.transferContentTo(target);
            }
            case POST_CONTENT: {
                return this.transfer(this.lazyLoadPostContentBuffer(), target, MultipartState.DONE);
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    private ByteBuf lazyLoadPreContentBuffer() {
        if (this.preContentBuffer == null) {
            this.preContentBuffer = this.computePreContentBytes(this.preContentLength);
        }
        return this.preContentBuffer;
    }

    private ByteBuf lazyLoadPostContentBuffer() {
        if (this.postContentBuffer == null) {
            this.postContentBuffer = this.computePostContentBytes(this.postContentLength);
        }
        return this.postContentBuffer;
    }

    @Override
    public void close() {
        if (this.preContentBuffer != null) {
            this.preContentBuffer.release();
        }
        if (this.postContentBuffer != null) {
            this.postContentBuffer.release();
        }
    }

    protected abstract long getContentLength();

    protected abstract long transferContentTo(ByteBuf var1) throws IOException;

    protected abstract long transferContentTo(WritableByteChannel var1) throws IOException;

    protected long transfer(ByteBuf source, ByteBuf target, MultipartState sourceFullyWrittenState) {
        int targetRemaining;
        int sourceRemaining = source.readableBytes();
        if (sourceRemaining <= (targetRemaining = target.writableBytes())) {
            target.writeBytes(source);
            this.state = sourceFullyWrittenState;
            return sourceRemaining;
        }
        target.writeBytes(source, targetRemaining);
        return targetRemaining;
    }

    protected long transfer(ByteBuf source, WritableByteChannel target, MultipartState sourceFullyWrittenState) throws IOException {
        int transferred = 0;
        if (target instanceof GatheringByteChannel) {
            transferred = source.readBytes((GatheringByteChannel)target, source.readableBytes());
        } else {
            for (ByteBuffer byteBuffer : source.nioBuffers()) {
                int len = byteBuffer.remaining();
                int written = target.write(byteBuffer);
                transferred += written;
                if (written != len) break;
            }
            source.readerIndex(source.readerIndex() + transferred);
        }
        if (source.isReadable()) {
            this.slowTarget = true;
        } else {
            this.state = sourceFullyWrittenState;
        }
        return transferred;
    }

    protected int computePreContentLength() {
        PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
        this.visitPreContent(counterVisitor);
        return counterVisitor.getCount();
    }

    protected ByteBuf computePreContentBytes(int preContentLength) {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(preContentLength);
        PartVisitor.ByteBufVisitor bytesVisitor = new PartVisitor.ByteBufVisitor(buffer);
        this.visitPreContent(bytesVisitor);
        return buffer;
    }

    protected int computePostContentLength() {
        PartVisitor.CounterPartVisitor counterVisitor = new PartVisitor.CounterPartVisitor();
        this.visitPostContent(counterVisitor);
        return counterVisitor.getCount();
    }

    protected ByteBuf computePostContentBytes(int postContentLength) {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(postContentLength);
        PartVisitor.ByteBufVisitor bytesVisitor = new PartVisitor.ByteBufVisitor(buffer);
        this.visitPostContent(bytesVisitor);
        return buffer;
    }

    protected void visitStart(PartVisitor visitor) {
        visitor.withBytes(EXTRA_BYTES);
        visitor.withBytes(this.boundary);
    }

    protected void visitDispositionHeader(PartVisitor visitor) {
        visitor.withBytes(CRLF_BYTES);
        visitor.withBytes(CONTENT_DISPOSITION_BYTES);
        visitor.withBytes(((PartBase)this.part).getDispositionType() != null ? ((PartBase)this.part).getDispositionType().getBytes(StandardCharsets.US_ASCII) : FORM_DATA_DISPOSITION_TYPE_BYTES);
        if (((PartBase)this.part).getName() != null) {
            visitor.withBytes(NAME_BYTES);
            visitor.withByte((byte)34);
            visitor.withBytes(((PartBase)this.part).getName().getBytes(StandardCharsets.US_ASCII));
            visitor.withByte((byte)34);
        }
    }

    protected void visitContentTypeHeader(PartVisitor visitor) {
        String contentType = ((PartBase)this.part).getContentType();
        if (contentType != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_TYPE_BYTES);
            visitor.withBytes(contentType.getBytes(StandardCharsets.US_ASCII));
            Charset charSet = ((PartBase)this.part).getCharset();
            if (charSet != null) {
                visitor.withBytes(CHARSET_BYTES);
                visitor.withBytes(((PartBase)this.part).getCharset().name().getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    protected void visitTransferEncodingHeader(PartVisitor visitor) {
        String transferEncoding = ((PartBase)this.part).getTransferEncoding();
        if (transferEncoding != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_TRANSFER_ENCODING_BYTES);
            visitor.withBytes(transferEncoding.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void visitContentIdHeader(PartVisitor visitor) {
        String contentId = ((PartBase)this.part).getContentId();
        if (contentId != null) {
            visitor.withBytes(CRLF_BYTES);
            visitor.withBytes(CONTENT_ID_BYTES);
            visitor.withBytes(contentId.getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void visitCustomHeaders(PartVisitor visitor) {
        if (MiscUtils.isNonEmpty(((PartBase)this.part).getCustomHeaders())) {
            for (Param param : ((PartBase)this.part).getCustomHeaders()) {
                visitor.withBytes(CRLF_BYTES);
                visitor.withBytes(param.getName().getBytes(StandardCharsets.US_ASCII));
                visitor.withBytes(HEADER_NAME_VALUE_SEPARATOR_BYTES);
                visitor.withBytes(param.getValue().getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    protected void visitEndOfHeaders(PartVisitor visitor) {
        visitor.withBytes(CRLF_BYTES);
        visitor.withBytes(CRLF_BYTES);
    }

    protected void visitPreContent(PartVisitor visitor) {
        this.visitStart(visitor);
        this.visitDispositionHeader(visitor);
        this.visitContentTypeHeader(visitor);
        this.visitTransferEncodingHeader(visitor);
        this.visitContentIdHeader(visitor);
        this.visitCustomHeaders(visitor);
        this.visitEndOfHeaders(visitor);
    }

    protected void visitPostContent(PartVisitor visitor) {
        visitor.withBytes(CRLF_BYTES);
    }
}

