/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.part.FileLikeMultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartState;
import org.asynchttpclient.util.MiscUtils;

public class FileMultipartPart
extends FileLikeMultipartPart<FilePart> {
    private final long length;
    private FileChannel channel;
    private long position = 0L;

    public FileMultipartPart(FilePart part, byte[] boundary) {
        super(part, boundary);
        File file = part.getFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("File part doesn't exist: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File part can't be read: " + file.getAbsolutePath());
        }
        this.length = file.length();
    }

    private FileChannel getChannel() throws IOException {
        if (this.channel == null) {
            this.channel = new RandomAccessFile(((FilePart)this.part).getFile(), "r").getChannel();
        }
        return this.channel;
    }

    @Override
    protected long getContentLength() {
        return ((FilePart)this.part).getFile().length();
    }

    @Override
    protected long transferContentTo(ByteBuf target) throws IOException {
        int transferred = target.writeBytes((ScatteringByteChannel)this.getChannel(), target.writableBytes());
        if (transferred > 0) {
            this.position += (long)transferred;
        }
        if (this.position == this.length || transferred < 0) {
            this.state = MultipartState.POST_CONTENT;
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
        return transferred;
    }

    @Override
    protected long transferContentTo(WritableByteChannel target) throws IOException {
        long transferred = this.getChannel().transferTo(this.position, 8192L, target);
        if (transferred > 0L) {
            this.position += transferred;
        }
        if (this.position == this.length || transferred < 0L) {
            this.state = MultipartState.POST_CONTENT;
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        } else {
            this.slowTarget = true;
        }
        return transferred;
    }

    @Override
    public void close() {
        super.close();
        MiscUtils.closeSilently(this.channel);
    }
}

