/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingIOCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereEventImpl> {
    public BlockingIOCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return "Unknown";
    }

    @Override
    public String getContainerDottedVersion() {
        return "Unknown";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
            this.suspend(action, req, res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            CountDownLatch latch = (CountDownLatch)req.getSession().getAttribute("org.atmosphere.container.latch");
            latch.countDown();
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND && this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending after Resuming" + res);
                this.suspend(action, req, res);
            }
        }
        return action;
    }

    private void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CountDownLatch latch = new CountDownLatch(1);
        req.getSession().setAttribute("org.atmosphere.container.latch", (Object)latch);
        try {
            if (action.timeout != -1L) {
                latch.await(action.timeout, TimeUnit.MILLISECONDS);
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            this.timedout(req, res);
        }
    }

    @Override
    public void action(AtmosphereEventImpl actionEvent) {
        block3: {
            try {
                if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                    CountDownLatch latch = (CountDownLatch)actionEvent.getRequest().getSession().getAttribute("org.atmosphere.container.latch");
                    latch.countDown();
                }
            }
            catch (Exception ex) {
                if (!this.logger.isLoggable(Level.FINE)) break block3;
                this.logger.log(Level.FINE, "", ex);
            }
        }
    }
}

