/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Servlet30Support
extends AsynchronousProcessor
implements CometSupport<AtmosphereEventImpl> {
    public Servlet30Support(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return "javax.servlet";
    }

    @Override
    public String getContainerDottedVersion() {
        return "3.0";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending" + res);
            }
            this.suspend(action, req, res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Resuming" + res);
            }
            AsyncContext asyncContext = (AsyncContext)req.getSession().getAttribute("org.atmosphere.container.asyncContext");
            asyncContext.complete();
            AtmosphereServlet.Action nextAction = this.resumed(req, res);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND && this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Suspending after Resuming" + res);
                this.suspend(action, req, res);
            }
        }
        return action;
    }

    private void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        req.addAsyncListener((AsyncListener)new CometListener());
        try {
            res.getWriter().flush();
        }
        catch (IllegalStateException ex) {
            res.getOutputStream().flush();
        }
        AsyncContext asyncContext = req.startAsync();
        req.getSession().setAttribute("org.atmosphere.container.asyncContext", (Object)asyncContext);
    }

    @Override
    public void action(AtmosphereEventImpl actionEvent) {
        if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
            AsyncContext asyncContext = (AsyncContext)actionEvent.getRequest().getSession().getAttribute("org.atmosphere.container.asyncContext");
            asyncContext.complete();
        }
    }

    private class CometListener
    implements AsyncListener {
        private CometListener() {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            if (Servlet30Support.this.logger.isLoggable(Level.FINE)) {
                Servlet30Support.this.logger.fine("Resumed (completed)" + event.getRequest());
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            block3: {
                if (Servlet30Support.this.logger.isLoggable(Level.FINE)) {
                    Servlet30Support.this.logger.fine("onTimeout" + event.getRequest());
                }
                try {
                    Servlet30Support.this.timedout((HttpServletRequest)event.getRequest(), (HttpServletResponse)event.getResponse());
                }
                catch (ServletException ex) {
                    if (!Servlet30Support.this.logger.isLoggable(Level.FINE)) break block3;
                    Servlet30Support.this.logger.log(Level.FINE, "onTimeout" + event.getRequest(), ex);
                }
            }
        }
    }
}

