/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereEventImpl> {
    public static final String COMET_EVENT = "CometEvent";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(TomcatCometSupport.unableToDetectComet());
    private final ConcurrentLinkedQueue<CometEvent> resumed = new ConcurrentLinkedQueue();

    public TomcatCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return "Tomcat";
    }

    @Override
    public String getContainerDottedVersion() {
        return "6.0.x";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action;
        block26: {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                throw unableToDetectComet;
            }
            action = null;
            if (event.getEventType() == CometEvent.EventType.BEGIN) {
                action = this.suspended(req, res);
                if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Suspending " + res);
                    }
                    try {
                        if (action.timeout != -1L) {
                            event.setTimeout((int)action.timeout);
                            break block26;
                        }
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    catch (UnsupportedOperationException ex) {}
                } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Resuming " + res);
                    }
                    event.close();
                } else {
                    event.close();
                }
            } else if (event.getEventType() != CometEvent.EventType.READ) {
                if (event.getEventSubType() == CometEvent.EventSubType.CLIENT_DISCONNECT) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Client closed connection " + res);
                    }
                    action = this.cancelled(req, res);
                    event.close();
                } else if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Timing out " + res);
                    }
                    action = this.timedout(req, res);
                    event.close();
                } else if (event.getEventType() == CometEvent.EventType.ERROR) {
                    event.close();
                } else if (event.getEventType() == CometEvent.EventType.END) {
                    if (!this.resumed.remove(event)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Client closed connection " + res);
                        }
                        action = this.cancelled(req, res);
                    } else if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Cancelling " + res);
                    }
                    event.close();
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereEventImpl actionEvent) {
        block3: {
            if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME) {
                try {
                    CometEvent event = (CometEvent)actionEvent.getRequest().getAttribute(COMET_EVENT);
                    this.resumed.offer(event);
                    event.close();
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.FINE)) break block3;
                    this.logger.log(Level.FINE, "", ex);
                }
            }
        }
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tomcat failed to detect this is a Comet application because context.xml ");
        sb.append("is missing or the Http11NioProtocol Connector is not enabled.");
        sb.append("\nEnable it or if enabled add the following content under your META-INF/context.xml of your war file.");
        sb.append("\n<Context>");
        sb.append("\t<Loader delegate=\"true\"/>");
        sb.append("\t</Context>");
        return sb.toString();
    }
}

