/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsynchronousProcessor
implements CometSupport<AtmosphereEventImpl> {
    private static final AtmosphereServlet.Action timedoutAction = new AtmosphereServlet.Action();
    private static final AtmosphereServlet.Action cancelledAction = new AtmosphereServlet.Action();
    protected final Logger logger = LoggerUtils.getLogger();
    protected static final String EVENT = "Context";
    private final AtmosphereServlet.AtmosphereConfig config;

    public AsynchronousProcessor(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
    }

    public AtmosphereServlet.Action suspended(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(suspend) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    AtmosphereServlet.Action action(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(true);
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.map(req.getServletPath());
        AtmosphereEventImpl event = new AtmosphereEventImpl(this.config, g.broadcaster, req, res, this);
        AtmosphereServlet.Action a = ((AtmosphereEventImpl)g.atmosphereHandler.onEvent(event)).action;
        if (event.isSuspended()) {
            session.setAttribute(EVENT, (Object)event);
        }
        return a;
    }

    AtmosphereServlet.AtmosphereHandlerWrapper map(String servletPath) throws ServletException {
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.config.handlers().get(servletPath);
        if (g == null) {
            servletPath = !servletPath.endsWith("/") ? servletPath + "/*" : servletPath + "*";
            g = this.config.handlers().get(servletPath);
            if (g == null) {
                throw new ServletException("Invalid AtmosphereHandler");
            }
        }
        this.config.ah = g.atmosphereHandler;
        this.config.getBroadcasterLookup().add(g.broadcaster);
        return g;
    }

    public AtmosphereServlet.Action resumed(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(resumed) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    public AtmosphereServlet.Action timedout(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        AtmosphereServlet.AtmosphereHandlerWrapper aw = this.map(req.getServletPath());
        AtmosphereEventImpl event = null;
        if (session != null) {
            event = (AtmosphereEventImpl)session.getAttribute(EVENT);
            event.isResumedOnTimeout = true;
        }
        if (event != null) {
            aw.atmosphereHandler.onMessage(event);
        }
        return timedoutAction;
    }

    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        block3: {
            try {
                HttpSession session = req.getSession();
                AtmosphereServlet.AtmosphereHandlerWrapper aw = this.map(req.getServletPath());
                AtmosphereEventImpl event = null;
                if (session != null) {
                    event = (AtmosphereEventImpl)session.getAttribute(EVENT);
                    event.setCancelled(true);
                    event.getBroadcaster().removeAtmosphereEvent(event);
                }
                aw.atmosphereHandler.onMessage(event);
            }
            catch (IllegalStateException ex) {
                if (!this.logger.isLoggable(Level.FINEST)) break block3;
                this.logger.log(Level.FINEST, "", ex);
            }
        }
        return cancelledAction;
    }
}

