/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereEvent;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.CometSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereEventImpl
implements AtmosphereEvent<HttpServletRequest, HttpServletResponse> {
    private HttpServletRequest req;
    private HttpServletResponse res;
    protected AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    protected Broadcaster broadcaster;
    protected Object message = null;
    private AtmosphereServlet.AtmosphereConfig config = null;
    protected boolean isResumedOnTimeout = false;
    protected CometSupport cometSupport;
    private boolean isCancelled;

    public AtmosphereEventImpl(AtmosphereServlet.AtmosphereConfig config, Broadcaster broadcaster, HttpServletRequest req, HttpServletResponse res, CometSupport cometSupport) {
        this.req = req;
        this.res = res;
        this.broadcaster = broadcaster;
        this.config = config;
        this.cometSupport = cometSupport;
    }

    @Override
    public void resume() {
        if (this.isSuspended()) {
            this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
            this.broadcaster.removeAtmosphereEvent(this);
            this.cometSupport.action(this);
        }
    }

    @Override
    public boolean isResuming() {
        return this.action.type == AtmosphereServlet.Action.TYPE.RESUME;
    }

    @Override
    public boolean isSuspended() {
        return this.action.type == AtmosphereServlet.Action.TYPE.SUSPEND;
    }

    @Override
    public void suspend() {
        this.suspend(-1L);
    }

    @Override
    public void suspend(long timeout) {
        if (!this.isResumedOnTimeout()) {
            this.action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
            this.action.timeout = timeout;
            this.broadcaster.addAtmosphereEvent(this);
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        if (this.isCancelled) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    @Override
    public HttpServletResponse getResponse() {
        if (this.isCancelled) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.res;
    }

    @Override
    public Broadcaster<Object> getBroadcaster() {
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    protected void reset(HttpServletRequest req, HttpServletResponse res) {
        this.action.timeout = -1L;
        this.action.type = AtmosphereServlet.Action.TYPE.NONE;
        this.req = req;
        this.res = res;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    protected void setMessage(Object message) {
        this.message = message;
    }

    @Override
    public AtmosphereServlet.AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    @Override
    public boolean isResumedOnTimeout() {
        return this.isResumedOnTimeout;
    }

    public AtmosphereServlet.Action action() {
        return this.action;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    protected void setCancelled(boolean isCancelled) {
        this.isCancelled = isCancelled;
    }
}

