/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.atmosphere.cpr.MessageTransformer;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcasterConfig<F> {
    private static final int numOfProcessor = Runtime.getRuntime().availableProcessors();
    private ConcurrentLinkedQueue<MessageTransformer<F>> transformers = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService defaultExecutorService = this.executorService = Executors.newFixedThreadPool(numOfProcessor);

    public BroadcasterConfig() {
        LoggerUtils.getLogger().info("DefaultBroadcaster configured using a Thread Pool of size: " + numOfProcessor);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean addMessageTransformer(MessageTransformer<F> e) {
        if (this.transformers.contains(e)) {
            return false;
        }
        return this.transformers.offer(e);
    }

    public boolean removeMessageTransformer(MessageTransformer<F> e) {
        return this.transformers.remove(e);
    }

    Object transform(F object) {
        F transformed = object;
        for (MessageTransformer<F> mf : this.transformers) {
            transformed = mf.transform(transformed);
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }
}

