/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.atmosphere.util.LoggerUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereConfigReader {
    private Logger logger = LoggerUtils.getLogger();
    final Map<String, String> tuples = new HashMap<String, String>();
    final Map<String, ArrayList<Property>> atmosphereHandlerProperties = new HashMap<String, ArrayList<Property>>();
    final Map<String, String> broadcasters = new HashMap<String, String>();

    public AtmosphereConfigReader(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.parse(factory.newDocumentBuilder().parse(stream));
        }
        catch (SAXException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList atmosphereHandlers = element.getElementsByTagName("atmosphere-handler");
        for (int i = 0; i < atmosphereHandlers.getLength(); ++i) {
            String broadcasterClass;
            Node atmosphereHandler = atmosphereHandlers.item(i);
            NamedNodeMap attrs = atmosphereHandler.getAttributes();
            NodeList properties = atmosphereHandler.getChildNodes();
            ArrayList<Property> list = new ArrayList<Property>();
            for (int j = 0; j < properties.getLength(); ++j) {
                Node property = properties.item(j);
                NamedNodeMap values = property.getAttributes();
                if (values == null) continue;
                list.add(new Property(values.getNamedItem("name").getNodeValue(), values.getNamedItem("value").getNodeValue()));
            }
            if (attrs == null) continue;
            this.atmosphereHandlerProperties.put(attrs.getNamedItem("class-name").getNodeValue(), list);
            this.addAtmosphereHandler(attrs.getNamedItem("context-root").getNodeValue(), attrs.getNamedItem("class-name").getNodeValue());
            if (attrs.getNamedItem("broadcaster") == null || (broadcasterClass = attrs.getNamedItem("broadcaster").getNodeValue()) == null) continue;
            this.broadcasters.put(attrs.getNamedItem("context-root").getNodeValue(), broadcasterClass);
        }
    }

    void addAtmosphereHandler(String contextPath, String className) {
        if (this.tuples.containsKey(contextPath)) {
            throw new RuntimeException("duplicate context root in configuration :" + contextPath);
        }
        this.tuples.put(contextPath, className);
    }

    public Map<String, String> getAtmosphereHandlers() {
        return this.tuples;
    }

    public String getBroadcasterClass(String contextRoot) {
        return this.broadcasters.get(contextRoot);
    }

    public ArrayList<Property> getProperty(String className) {
        return this.atmosphereHandlerProperties.get(className);
    }

    public class Property {
        public String name = "";
        public String value = "";

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

