/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.atmosphere.cpr.Broadcaster;

public class BroadcasterLookup {
    private static final ConcurrentLinkedQueue<Broadcaster> store = new ConcurrentLinkedQueue();

    public final Broadcaster lookup(String name) throws OutOfScopeException {
        Broadcaster b = this.getBroadcaster(name);
        if (b != null && b.getScope() == Broadcaster.SCOPE.REQUEST) {
            throw new OutOfScopeException(b);
        }
        return b;
    }

    Broadcaster getBroadcaster(String name) {
        for (Broadcaster b : store) {
            if (!b.getName().equals(name)) continue;
            return b;
        }
        return null;
    }

    public final boolean add(Broadcaster b) {
        return store.offer(b);
    }

    public final boolean remove(Broadcaster b) {
        return store.remove(b);
    }

    public static class OutOfScopeException
    extends Exception {
        public OutOfScopeException(Broadcaster b) {
            super("Broadcaster " + b.getName() + " cannot be used. Out of scope");
        }
    }
}

