/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cache.BroadcasterCacheBase;
import org.atmosphere.cpr.AtmosphereResource;

public class HeaderBroadcasterCache
extends BroadcasterCacheBase {
    @Override
    public void cache(AtmosphereResource<HttpServletRequest, HttpServletResponse> r, BroadcasterCacheBase.CachedMessage cm) {
        long time = cm.next() == null ? cm.currentTime() : cm.next().currentTime();
        r.getResponse().addHeader("X-Cache-Date", String.valueOf(time));
    }

    @Override
    public BroadcasterCacheBase.CachedMessage retrieveLastMessage(AtmosphereResource<HttpServletRequest, HttpServletResponse> r) {
        HttpServletRequest request = r.getRequest();
        return this.retrieveUsingHeader(request.getHeader("X-Cache-Date"));
    }

    public BroadcasterCacheBase.CachedMessage retrieveUsingHeader(String dateString) {
        if (dateString == null) {
            return null;
        }
        long currentTime = Long.valueOf(dateString);
        BroadcasterCacheBase.CachedMessage prev = null;
        for (BroadcasterCacheBase.CachedMessage cm : this.queue) {
            if (cm.currentTime() > currentTime) {
                return prev;
            }
            prev = cm;
        }
        return prev;
    }
}

