/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet30CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Servlet30CometSupport.class);

    public Servlet30CometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return super.getContainerName() + " using javax.servlet/3.0";
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AtmosphereServlet.Action action = this.suspended(request, response);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)response);
            this.suspend(action, request, response);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            AsyncContext asyncContext;
            logger.debug("Resuming response: {}", (Object)response);
            if (this.supportSession() && (asyncContext = (AsyncContext)request.getSession().getAttribute("org.atmosphere.container.asyncContext")) != null) {
                asyncContext.complete();
            }
            AtmosphereServlet.Action nextAction = this.resumed(request, response);
            if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending after resuming response: {}", (Object)response);
                this.suspend(action, request, response);
            }
        }
        return action;
    }

    private void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (!req.isAsyncStarted()) {
            AsyncContext asyncContext = req.startAsync();
            asyncContext.addListener((AsyncListener)new CometListener());
            if (action.timeout != -1L) {
                asyncContext.setTimeout(action.timeout);
            } else {
                asyncContext.setTimeout(Integer.MAX_VALUE);
            }
            req.setAttribute("org.atmosphere.container.asyncContext", (Object)asyncContext);
            if (this.supportSession()) {
                req.getSession().setAttribute("org.atmosphere.container.asyncContext", (Object)asyncContext);
            }
        }
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && actionEvent.isInScope()) {
            AsyncContext asyncContext = (AsyncContext)actionEvent.getRequest().getAttribute("org.atmosphere.container.asyncContext");
            if (asyncContext == null && this.supportSession()) {
                asyncContext = (AsyncContext)actionEvent.getRequest().getSession().getAttribute("org.atmosphere.container.asyncContext");
            }
            if (asyncContext != null && (this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(ApplicationConfig.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false"))) {
                asyncContext.complete();
            }
        } else if (!actionEvent.isInScope()) {
            logger.debug("Already resumed or cancelled: event: {}", (Object)actionEvent);
        }
    }

    private class CometListener
    implements AsyncListener {
        private CometListener() {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            logger.debug("Resumed (completed): event: {}", (Object)event.getAsyncContext().getRequest());
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            logger.debug("onTimeout(): event: {}", (Object)event.getAsyncContext().getRequest());
            try {
                Servlet30CometSupport.this.timedout((HttpServletRequest)event.getAsyncContext().getRequest(), (HttpServletResponse)event.getAsyncContext().getResponse());
            }
            catch (ServletException ex) {
                logger.debug("onTimeout(): failed timing out comet response: " + event.getAsyncContext().getResponse(), (Throwable)ex);
            }
        }

        public void onError(AsyncEvent event) {
            logger.debug("onError(): event: {}", (Object)event.getAsyncContext().getResponse());
            try {
                Servlet30CometSupport.this.cancelled((HttpServletRequest)event.getAsyncContext().getRequest(), (HttpServletResponse)event.getAsyncContext().getResponse());
            }
            catch (Throwable ex) {
                logger.debug("failed cancelling comet response: " + event.getAsyncContext().getResponse(), ex);
            }
        }

        public void onStartAsync(AsyncEvent event) {
            logger.debug("onStartAsync(): event: {}", (Object)event.getAsyncContext().getResponse());
        }
    }
}

