/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.di.InjectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBroadcasterFactory
extends BroadcasterFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBroadcasterFactory.class);
    private final ConcurrentHashMap<Object, Broadcaster> store = new ConcurrentHashMap();
    private final Class<? extends Broadcaster> clazz;
    private BroadcasterLifeCyclePolicy policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();

    protected DefaultBroadcasterFactory(Class<? extends Broadcaster> clazz, String broadcasterLifeCyclePolicy, AtmosphereServlet.AtmosphereConfig c) {
        this.clazz = clazz;
        config = c;
        if (factory == null) {
            factory = this;
        }
        this.configure(broadcasterLifeCyclePolicy);
    }

    private void configure(String broadcasterLifeCyclePolicy) {
        int maxIdleTime = 300000;
        String idleTime = config.getInitParameter(ApplicationConfig.BROADCASTER_LIFECYCLE_POLICY_IDLETIME);
        if (idleTime != null) {
            maxIdleTime = Integer.parseInt(idleTime);
        }
        if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME).idleTimeInMS(maxIdleTime).build();
        } else if (BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER.name().equalsIgnoreCase(broadcasterLifeCyclePolicy)) {
            this.policy = new BroadcasterLifeCyclePolicy.Builder().policy(BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.NEVER).build();
        } else {
            logger.warn("Unsupported BroadcasterLifeCyclePolicy policy {}", (Object)broadcasterLifeCyclePolicy);
        }
    }

    @Override
    public final synchronized Broadcaster get() {
        return this.get(this.clazz.getSimpleName() + "-" + UUID.randomUUID());
    }

    @Override
    public final Broadcaster get(Object id) {
        return this.get(this.clazz, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Broadcaster get(Class<? extends Broadcaster> c, Object id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (c == null) {
            throw new NullPointerException("Class is null");
        }
        if (this.getBroadcaster(id) != null) {
            throw new IllegalStateException("Broadcaster already existing " + id + ". Use BroadcasterFactory.lookup instead");
        }
        Broadcaster b = null;
        Object object = id;
        synchronized (object) {
            if (this.store.get(id) != null) {
                return this.store.get(id);
            }
            try {
                b = c.getConstructor(String.class, AtmosphereServlet.AtmosphereConfig.class).newInstance(id.toString(), config);
            }
            catch (Throwable t) {
                throw new BroadcasterCreationException(t);
            }
            InjectorProvider.getInjector().inject(b);
            b.setBroadcasterConfig(new BroadcasterConfig(AtmosphereServlet.broadcasterFilters, config));
            b.setBroadcasterLifeCyclePolicy(this.policy);
            if (DefaultBroadcaster.class.isAssignableFrom(this.clazz)) {
                ((DefaultBroadcaster)DefaultBroadcaster.class.cast(b)).start();
            }
            this.store.put(id, b);
            logger.debug("Added Broadcaster {} . Factory size: {}", id, (Object)this.store.size());
        }
        return b;
    }

    private Broadcaster getBroadcaster(Object name) {
        return this.store.get(name);
    }

    @Override
    public boolean add(Broadcaster b, Object id) {
        return this.store.put(id, b) == null;
    }

    @Override
    public boolean remove(Broadcaster b, Object id) {
        boolean removed;
        boolean bl = removed = this.store.get(b.getID()) == b;
        if (removed) {
            this.store.remove(id, b);
            logger.debug("Removing Broadcaster {} which internal reference is {} ", id, (Object)b.getID());
        }
        return removed;
    }

    @Override
    public final Broadcaster lookup(Class<? extends Broadcaster> c, Object id) {
        return this.lookup(c, id, false);
    }

    @Override
    public final Broadcaster lookup(Object id) {
        return this.lookup(this.clazz, id, false);
    }

    @Override
    public final Broadcaster lookup(Object id, boolean createIfNull) {
        return this.lookup(this.clazz, id, createIfNull);
    }

    @Override
    public Broadcaster lookup(Class<? extends Broadcaster> c, Object id, boolean createIfNull) {
        Broadcaster b = this.getBroadcaster(id);
        if (b != null && !c.isAssignableFrom(b.getClass())) {
            String msg = "Invalid lookup class " + c.getName() + ". Cached class is: " + b.getClass().getName();
            logger.debug("{}", (Object)msg);
            throw new IllegalStateException(msg);
        }
        if (b == null && createIfNull || b != null && b.isDestroyed()) {
            if (b != null) {
                logger.debug("Removing destroyed Broadcaster {}", (Object)b.getID());
                this.store.remove(b.getID(), b);
            }
            b = this.get(c, id);
        }
        return b;
    }

    @Override
    public void removeAllAtmosphereResource(AtmosphereResource<?, ?> r) {
        try {
            if (this.store.size() > 0) {
                for (Broadcaster b : this.lookupAll()) {
                    try {
                        if (!b.getAtmosphereResources().contains(r)) continue;
                        b.removeAtmosphereResource(r);
                    }
                    catch (IllegalStateException ex) {
                        logger.trace(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Collection<Broadcaster> lookupAll() {
        return Collections.unmodifiableCollection(this.store.values());
    }

    @Override
    public synchronized void destroy() {
        Enumeration<Broadcaster> e = this.store.elements();
        BroadcasterConfig bc = null;
        while (e.hasMoreElements()) {
            try {
                Broadcaster b = e.nextElement();
                b.resumeAll();
                b.destroy();
                bc = b.getBroadcasterConfig();
            }
            catch (Throwable t) {
                logger.trace("Destroy", t);
            }
        }
        try {
            if (bc != null) {
                bc.forceDestroy();
            }
        }
        catch (Throwable t) {
            logger.trace("Destroy", t);
        }
        this.store.clear();
        factory = null;
    }

    public static BroadcasterFactory buildAndReplaceDefaultfactory(Class<? extends Broadcaster> clazz, AtmosphereServlet.AtmosphereConfig c) throws InstantiationException, IllegalAccessException {
        factory = new DefaultBroadcasterFactory(clazz, "NEVER", c);
        return factory;
    }

    public static final class BroadcasterCreationException
    extends RuntimeException {
        public BroadcasterCreationException(Throwable t) {
            super(t);
        }
    }
}

