/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.DefaultWebSocket;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketEngine;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.GrizzlyCometSupport;
import org.atmosphere.container.version.GrizzlyWebSocket;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlassFishWebSocketSupport
extends GrizzlyCometSupport {
    private static final Logger logger = LoggerFactory.getLogger(GlassFishWebSocketSupport.class);

    public GlassFishWebSocketSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        WebSocketEngine.getEngine().register((WebSocketApplication)new GrizzlyApplication(this.config));
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean webSocketEnabled = false;
        if (request.getHeaders("Connection") != null && request.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)request.getHeaders("Connection").nextElement()).split(",")) {
                if (!upgrade.equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if (!webSocketEnabled) {
            return super.service(request, response);
        }
        AtmosphereServlet.Action action = this.suspended(request, response);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)response);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resuming response: {}", (Object)response);
        }
        return action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    private static final class GrizzlyApplication
    extends WebSocketApplication {
        private final AtmosphereServlet.AtmosphereConfig config;
        private WebSocketProcessor webSocketProcessor;

        public GrizzlyApplication(AtmosphereServlet.AtmosphereConfig config) {
            this.config = config;
        }

        public void onConnect(WebSocket w) {
            super.onConnect(w);
            if (!DefaultWebSocket.class.isAssignableFrom(w.getClass())) {
                throw new IllegalStateException();
            }
            DefaultWebSocket webSocket = (DefaultWebSocket)DefaultWebSocket.class.cast(w);
            try {
                this.webSocketProcessor = new WebSocketProcessor(this.config.getServlet(), new GrizzlyWebSocket((WebSocket)webSocket), this.config.getServlet().getWebSocketProtocol());
                this.webSocketProcessor.dispatch(webSocket.getRequest());
            }
            catch (Exception e) {
                logger.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public boolean isApplicationRequest(Request request) {
            return true;
        }

        public void onClose(WebSocket w, DataFrame df) {
            super.onClose(w, df);
            logger.debug("onClose {} ");
            this.webSocketProcessor.close();
        }

        public void onMessage(WebSocket w, String text) {
            logger.debug("onMessage {} ");
            this.webSocketProcessor.invokeWebSocketProtocol(text);
        }

        public void onMessage(WebSocket w, byte[] bytes) {
            logger.debug("onMessage (bytes) {} ");
            this.webSocketProcessor.invokeWebSocketProtocol(bytes, 0, bytes.length);
        }

        public void onPing(WebSocket w, byte[] bytes) {
            logger.debug("onPing (bytes) {} ");
        }

        public void onPong(WebSocket w, byte[] bytes) {
            logger.debug("onPong (bytes) {} ");
        }

        public void onFragment(WebSocket w, byte[] bytes, boolean last) {
            logger.debug("onFragment (bytes) {} ");
        }

        public void onFragment(WebSocket w, String text, boolean last) {
            logger.debug("onFragment (string) {} ");
        }
    }
}

