/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.JettyWebSocketHandler;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketUtil {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketUtil.class);

    public static final AtmosphereServlet.Action doService(AsynchronousProcessor cometSupport, HttpServletRequest req, HttpServletResponse res, WebSocketFactory webSocketFactory) throws IOException, ServletException {
        Boolean b;
        boolean webSocketEnabled = false;
        if (req.getHeaders("Connection") != null && req.getHeaders("Connection").hasMoreElements()) {
            String[] e;
            for (String upgrade : e = ((String)req.getHeaders("Connection").nextElement()).split(",")) {
                if (!upgrade.trim().equalsIgnoreCase("Upgrade")) continue;
                webSocketEnabled = true;
                break;
            }
        }
        if ((b = (Boolean)req.getAttribute(WebSocket.WEBSOCKET_INITIATED)) == null) {
            b = Boolean.FALSE;
        }
        if (!webSocketEnabled) {
            return null;
        }
        if (webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(WebSocket.WEBSOCKET_INITIATED, (Object)true);
            webSocketFactory.acceptWebSocket(req, res);
            return new AtmosphereServlet.Action();
        }
        AtmosphereServlet.Action action = cometSupport.suspended(req, res);
        if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
            logger.debug("Suspending response: {}", (Object)res);
        } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
            logger.debug("Resume response: {}", (Object)res);
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, (Object)true);
        }
        return action;
    }

    public static final WebSocketFactory getFactory(final AtmosphereServlet.AtmosphereConfig config) {
        WebSocketFactory webSocketFactory = new WebSocketFactory(new WebSocketFactory.Acceptor(){

            public boolean checkOrigin(HttpServletRequest request, String origin) {
                logger.debug("WebSocket-checkOrigin request {} with origin {}", (Object)request.getRequestURI(), (Object)origin);
                return true;
            }

            public org.eclipse.jetty.websocket.WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                logger.debug("WebSocket-connect request {} with protocol {}", (Object)request.getRequestURI(), (Object)protocol);
                return new JettyWebSocketHandler(request, config.getServlet(), config.getServlet().getWebSocketProtocol());
            }
        });
        int bufferSize = 8192;
        if (config.getInitParameter("org.atmosphere.websocket.bufferSize") != null) {
            bufferSize = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.bufferSize"));
        }
        logger.info("WebSocket Buffer side {}", (Object)bufferSize);
        webSocketFactory.setBufferSize(bufferSize);
        int timeOut = 300000;
        if (config.getInitParameter("org.atmosphere.websocket.maxIdleTime") != null) {
            timeOut = Integer.valueOf(config.getInitParameter("org.atmosphere.websocket.maxIdleTime"));
        }
        logger.info("WebSocket idle timeout {}", (Object)timeOut);
        webSocketFactory.setMaxIdleTime(timeOut);
        return webSocketFactory;
    }
}

