/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.atmosphere.cpr.FrameworkConfig;

public class AtmosphereRequest
extends HttpServletRequestWrapper {
    private final ByteInputStream bis;
    private final BufferedReader br;
    private final String pathInfo;
    private final Map<String, String> headers;
    private final Map<String, String[]> queryStrings;
    private final String methodType;
    private final String contentType;
    private HttpServletRequest request;
    private final String servletPath;
    private final String requestURI;
    private final String requestURL;
    private final Map<String, Object> localAttributes;

    private AtmosphereRequest(Builder b) {
        super(b.request);
        this.pathInfo = b.pathInfo == null ? b.request.getPathInfo() : b.pathInfo;
        this.request = b.request;
        this.headers = b.headers == null ? new HashMap() : b.headers;
        this.queryStrings = b.queryStrings == null ? new HashMap() : b.queryStrings;
        this.servletPath = b.servletPath;
        this.requestURI = b.requestURI;
        this.requestURL = b.requestURL;
        this.localAttributes = b.localAttributes;
        if (b.dataBytes != null) {
            this.bis = new ByteInputStream(b.dataBytes, b.offset, b.length);
            try {
                this.br = new BufferedReader(new StringReader(new String(b.dataBytes, b.offset, b.length, b.encoding)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else if (b.data != null) {
            this.bis = new ByteInputStream(b.data.getBytes(), 0, b.data.getBytes().length);
            this.br = new BufferedReader(new StringReader(b.data));
        } else {
            this.bis = null;
            this.br = null;
        }
        String string = b.methodType == null ? (this.request != null ? this.request.getMethod() : "GET") : (this.methodType = b.methodType);
        this.contentType = b.contentType == null ? (this.request != null ? this.request.getContentType() : "text/plain") : b.contentType;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getMethod() {
        return this.methodType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getServletPath() {
        return this.servletPath != null ? this.servletPath : super.getServletPath();
    }

    public String getRequestURI() {
        return this.requestURI != null ? this.requestURI : (this.request != null ? super.getRequestURI() : null);
    }

    public StringBuffer getRequestURL() {
        return this.requestURL != null ? new StringBuffer(this.requestURL) : (this.request != null ? this.request.getRequestURL() : null);
    }

    public Enumeration getHeaders(String name) {
        ArrayList list = Collections.list(super.getHeaders(name));
        if (name.equalsIgnoreCase("content-type")) {
            list.add(this.contentType);
        }
        if (this.headers.get(name) != null) {
            list.add(this.headers.get(name));
        }
        if (this.request != null && list.size() == 0 && name.startsWith("X-Atmosphere") && this.request.getAttribute(name) != null) {
            list.add(this.request.getAttribute(name));
        }
        return Collections.enumeration(list);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList list = Collections.list(super.getHeaderNames());
        list.add("content-type");
        if (this.request != null) {
            Enumeration e = this.request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                if (!name.startsWith("X-Atmosphere")) continue;
                list.add(name);
            }
        }
        list.addAll(this.headers.keySet());
        return Collections.enumeration(list);
    }

    public String getHeader(String s) {
        if (s.equalsIgnoreCase("Connection")) {
            return "keep-alive";
        }
        if ("content-type".equalsIgnoreCase(s)) {
            return this.contentType;
        }
        String name = super.getHeader(s);
        if (name == null) {
            if (this.headers.get(s) != null) {
                return this.headers.get(s);
            }
            if (s.startsWith("X-Atmosphere") && this.request != null) {
                return (String)this.request.getAttribute(s);
            }
        }
        return name;
    }

    public String getParameter(String s) {
        String name = super.getParameter(s);
        if (name == null && this.queryStrings.get(s) != null) {
            return this.queryStrings.get(s)[0];
        }
        return name;
    }

    public Map<String, String[]> getParameterMap() {
        Map m = this.request != null ? this.request.getParameterMap() : Collections.emptyMap();
        for (Map.Entry e : m.entrySet()) {
            String[] s = this.queryStrings.get(e.getKey());
            if (s != null) {
                String[] s1 = new String[s.length + ((String[])e.getValue()).length];
                System.arraycopy(s, 0, s1, 0, s.length);
                System.arraycopy(s1, s.length + 1, e.getValue(), 0, ((String[])e.getValue()).length);
                this.queryStrings.put((String)e.getKey(), s1);
                continue;
            }
            this.queryStrings.put((String)e.getKey(), (String[])e.getValue());
        }
        return Collections.unmodifiableMap(this.queryStrings);
    }

    public String[] getParameterValues(String s) {
        String[] list;
        String[] stringArray = list = super.getParameterValues(s) == null ? new String[]{} : super.getParameterValues(s);
        if (this.queryStrings.get(s) != null) {
            String[] newList = this.queryStrings.get(s);
            String[] s1 = new String[list.length + newList.length];
            System.arraycopy(list, 0, s1, 0, list.length);
            System.arraycopy(s1, list.length + 1, newList, 0, newList.length);
        }
        return list;
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.bis == null ? (this.request != null ? this.request.getInputStream() : null) : this.bis;
    }

    public BufferedReader getReader() throws IOException {
        return this.br == null ? (this.request != null ? this.request.getReader() : null) : this.br;
    }

    public void setAttribute(String s, Object o) {
        this.localAttributes.put(s, o);
    }

    public Object getAttribute(String s) {
        return this.localAttributes.get(s) != null ? this.localAttributes.get(s) : (this.request != null ? this.request.getAttribute(s) : null);
    }

    public void removeAttribute(String name) {
        if (this.localAttributes.remove(name) == null && this.request != null) {
            this.request.removeAttribute(name);
        }
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration e;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(this.localAttributes);
        Enumeration enumeration = e = this.request != null ? this.request.getAttributeNames() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                m.put(s, this.request.getAttribute(s));
            }
        }
        return Collections.enumeration(m.keySet());
    }

    public void destroy() {
        this.localAttributes.clear();
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.headers.clear();
        this.queryStrings.clear();
        if (this.request != null) {
            this.request.removeAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
            this.request = null;
        }
    }

    public static final class Builder {
        private HttpServletRequest request;
        private String pathInfo;
        private byte[] dataBytes;
        private int offset;
        private int length;
        private String encoding = "UTF-8";
        private String methodType;
        private String contentType;
        private String data;
        private Map<String, String> headers;
        private Map<String, String[]> queryStrings;
        private String servletPath;
        private String requestURI;
        private String requestURL;
        private Map<String, Object> localAttributes = new HashMap<String, Object>();

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.localAttributes = attributes;
            return this;
        }

        public Builder request(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder servletPath(String servletPath) {
            this.servletPath = servletPath;
            return this;
        }

        public Builder requestURI(String requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder requestURL(String requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        public Builder pathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
            return this;
        }

        public Builder body(byte[] dataBytes, int offset, int length) {
            this.dataBytes = dataBytes;
            this.offset = offset;
            this.length = length;
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder method(String methodType) {
            this.methodType = methodType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(String data) {
            this.data = data;
            return this;
        }

        public AtmosphereRequest build() {
            return new AtmosphereRequest(this);
        }

        public Builder queryStrings(Map<String, String[]> queryStrings) {
            this.queryStrings = queryStrings;
            return this;
        }
    }

    private static final class ByteInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream bis;

        public ByteInputStream(byte[] data, int offset, int length) {
            this.bis = new ByteArrayInputStream(data, offset, length);
        }

        public int read() throws IOException {
            return this.bis.read();
        }
    }
}

