/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import javax.servlet.http.HttpSession;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cpr.AtmosphereResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBroadcasterCache
extends AbstractBroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionBroadcasterCache.class);
    private static final String ERROR_MESSAGE = "Session was null. The request has been recycled by the underlying container";

    @Override
    public void cache(String id, AtmosphereResource r, AbstractBroadcasterCache.CachedMessage cm) {
        if (r != null) {
            HttpSession session = r.session();
            if (session == null) {
                logger.error(ERROR_MESSAGE);
                return;
            }
            session.setAttribute(id, (Object)cm);
        }
    }

    @Override
    public AbstractBroadcasterCache.CachedMessage retrieveLastMessage(String id, AtmosphereResource r) {
        HttpSession session = r.session();
        if (session == null) {
            logger.error(ERROR_MESSAGE);
            return null;
        }
        return (AbstractBroadcasterCache.CachedMessage)session.getAttribute(id);
    }
}

