/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.util.FakeHttpSession;
import org.atmosphere.util.QueryStringDecoder;
import org.atmosphere.util.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereRequest
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereRequest.class);
    private ServletInputStream bis;
    private BufferedReader br;
    private final Builder b;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private boolean queryComputed = false;
    private boolean cookieComputed = false;
    private volatile BufferedReader voidReader;
    private final ServletInputStream voidStream = new IS(new ByteArrayInputStream(new byte[0]));
    private AtomicBoolean streamSet = new AtomicBoolean();
    private AtomicBoolean readerSet = new AtomicBoolean();
    private String uuid;

    private AtmosphereRequest(Builder b) {
        super((HttpServletRequest)(b.request == null ? new NoOpsRequest() : b.request));
        if (b.request == null) {
            b.request(new NoOpsRequest());
        }
        this.b = b;
    }

    private BufferedReader getVoidReader() {
        if (this.voidReader == null) {
            this.voidReader = new BufferedReader(new StringReader(""), 5);
        }
        return this.voidReader;
    }

    private ServletInputStream configureStream() {
        if (this.bis == null && !this.streamSet.getAndSet(true)) {
            if (this.b.inputStream != null) {
                this.bis = new IS(this.b.inputStream);
            } else if (this.b.reader == null) {
                if (this.b.body.dataBytes != null) {
                    this.bis = new ByteInputStream(this.b.body.dataBytes, this.b.body.offset, this.b.body.length);
                } else if (this.b.body.data != null) {
                    try {
                        byte[] bytes = this.b.body.data.getBytes("UTF-8");
                        this.bis = new ByteInputStream(bytes, 0, bytes.length);
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.trace("", (Throwable)e);
                    }
                }
            } else {
                this.bis = new IS(new ReaderInputStream(this.b.reader));
            }
        }
        return this.bis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BufferedReader configureReader() {
        if (this.br != null || this.readerSet.getAndSet(false)) return this.br;
        if (this.b.reader != null) {
            this.br = new BufferedReader(this.b.reader);
            return this.br;
        } else if (this.b.inputStream == null) {
            try {
                if (this.b.body.dataBytes != null) {
                    this.br = new BufferedReader(new StringReader(new String(this.b.body.dataBytes, this.b.body.offset, this.b.body.length, this.b.encoding)));
                    return this.br;
                }
                if (this.b.body.data == null) return this.br;
                this.br = new BufferedReader(new StringReader(this.b.body.data));
                return this.br;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.br = new BufferedReader(new InputStreamReader(this.b.inputStream));
        }
        return this.br;
    }

    public boolean destroyed() {
        return this.destroyed.get();
    }

    public AtmosphereRequest destroyable(boolean destroyable) {
        this.b.destroyable = destroyable;
        return this;
    }

    public String getPathInfo() {
        return this.b.pathInfo != "" ? this.b.pathInfo : (this.isNotNoOps() ? this.b.request.getPathInfo() : "");
    }

    public String getPathTranslated() {
        return this.b.request.getPathTranslated();
    }

    public String getQueryString() {
        return this.b.queryString != "" ? this.b.queryString : (this.isNotNoOps() ? this.b.request.getQueryString() : this.toQs());
    }

    private String toQs() {
        StringBuilder q = new StringBuilder();
        for (Map.Entry e : this.b.queryStrings.entrySet()) {
            for (String k : (String[])e.getValue()) {
                q.append((String)e.getKey()).append("=").append(k).append("&");
            }
        }
        if (q.length() > 0) {
            q.deleteCharAt(q.length() - 1);
        }
        return q.toString();
    }

    public String getRemoteUser() {
        return this.b.principal != null ? this.b.principal.getName() : this.b.request.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return this.b.request.getRequestedSessionId();
    }

    public String getMethod() {
        return this.b.methodType != null ? this.b.methodType : this.b.request.getMethod();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return this.b.request.getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.b.request.getParts();
    }

    public String getContentType() {
        return this.b.contentType != null ? this.b.contentType : this.b.request.getContentType();
    }

    public DispatcherType getDispatcherType() {
        return this.b.request.getDispatcherType();
    }

    public String getServletPath() {
        return this.b.servletPath != "" ? this.b.servletPath : (this.isNotNoOps() ? this.b.request.getServletPath() : "");
    }

    public String getRequestURI() {
        return this.b.requestURI != null ? this.b.requestURI : (this.isNotNoOps() ? this.b.request.getRequestURI() : "");
    }

    public StringBuffer getRequestURL() {
        return this.b.requestURL != null ? new StringBuffer(this.b.requestURL) : (this.isNotNoOps() ? this.b.request.getRequestURL() : new StringBuffer());
    }

    public Enumeration getHeaders(String name) {
        ArrayList<Object> list = new ArrayList();
        if (!name.equalsIgnoreCase("content-type")) {
            list = Collections.list(this.b.request.getHeaders(name));
        }
        if (name.equalsIgnoreCase("content-type")) {
            String s = this.getContentType();
            if (s != null) {
                list.add(s);
            }
        } else {
            if (this.b.headers.get(name) != null) {
                list.add(this.b.headers.get(name));
            }
            if (this.isNotNoOps() && list.size() == 0 && name.startsWith("X-Atmosphere") && AtmosphereRequest.attributeWithoutException(this.b.request, name) != null) {
                list.add(AtmosphereRequest.attributeWithoutException(this.b.request, name));
            }
        }
        return Collections.enumeration(list);
    }

    public int getIntHeader(String name) {
        return this.b.request.getIntHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet<Object> list = new HashSet<Object>();
        list.addAll(this.b.headers.keySet());
        list.addAll(Collections.list(this.b.request.getHeaderNames()));
        if (this.b.request != null) {
            Enumeration e = this.b.request.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                if (!name.startsWith("X-Atmosphere")) continue;
                list.add(name);
            }
        }
        if (this.b.contentType != null) {
            list.add("Content-Type");
        }
        return Collections.enumeration(list);
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.b.request.authenticate(response);
    }

    public String getAuthType() {
        return this.b.authType != null ? this.b.authType : this.b.request.getAuthType();
    }

    public String getContextPath() {
        String c = "/";
        try {
            c = this.isNotNoOps() && this.b.request.getContextPath() != null ? this.b.request.getContextPath() : (this.b.contextPath != null ? this.b.contextPath : "");
        }
        catch (NullPointerException ex) {
            logger.warn("Unexpected getContextPath exception. Forcing `/`", (Throwable)ex);
        }
        return c;
    }

    public Cookie[] getCookies() {
        if (!this.cookieComputed) {
            this.cookieComputed = true;
            Cookie[] c = this.b.request.getCookies();
            if (c != null && c.length > 0) {
                this.b.cookies.addAll(Arrays.asList(c));
            }
        }
        return this.b.cookies.toArray(new Cookie[0]);
    }

    public long getDateHeader(String name) {
        return this.b.request.getDateHeader(name);
    }

    public String getHeader(String s) {
        return this.getHeader(s, true);
    }

    public HttpServletRequest wrappedRequest() {
        return this.b.request;
    }

    public String getHeader(String s, boolean checkCase) {
        String name;
        block11: {
            if ("content-type".equalsIgnoreCase(s)) {
                return this.getContentType();
            }
            name = this.b.request.getHeader(s);
            if (name == null) {
                if (this.b.headers.get(s) != null) {
                    return (String)this.b.headers.get(s);
                }
                if (s.startsWith("X-Atmosphere") && this.isNotNoOps()) {
                    Object o = AtmosphereRequest.attributeWithoutException(this.b.request, s);
                    if (o == null || String.class.isAssignableFrom(o.getClass())) {
                        name = (String)String.class.cast(o);
                    } else {
                        try {
                            if (!HttpServletRequestWrapper.class.isAssignableFrom(this.b.request.getClass())) break block11;
                            HttpServletRequest hsr = (HttpServletRequest)HttpServletRequestWrapper.class.cast(this.b.request);
                            while (hsr instanceof HttpServletRequestWrapper) {
                                o = AtmosphereRequest.attributeWithoutException(hsr = (HttpServletRequest)((HttpServletRequestWrapper)hsr).getRequest(), s);
                                if (o != null && !String.class.isAssignableFrom(o.getClass())) continue;
                                name = (String)String.class.cast(o);
                                break;
                            }
                        }
                        catch (Exception ex) {
                            logger.warn("", (Throwable)ex);
                        }
                    }
                }
            }
        }
        if (name == null && checkCase) {
            return this.getHeader(s.toLowerCase(), false);
        }
        if (name == null && "connection".equalsIgnoreCase(s)) {
            return "keep-alive";
        }
        return name;
    }

    public String getParameter(String s) {
        String name;
        String string = name = this.isNotNoOps() ? this.b.request.getParameter(s) : null;
        if (name == null && this.b.queryStrings.get(s) != null) {
            return ((String[])this.b.queryStrings.get(s))[0];
        }
        return name;
    }

    public Map<String, String[]> getParameterMap() {
        if (!this.queryComputed) {
            this.queryComputed = true;
            Map m = this.isNotNoOps() ? this.b.request.getParameterMap() : Collections.emptyMap();
            for (String e : m.keySet()) {
                this.b.queryStrings.put(e, this.getParameterValues(e));
            }
        }
        return Collections.unmodifiableMap(this.b.queryStrings);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String s) {
        Object[] list = this.b.request.getParameterValues(s);
        if (list != null && this.b.queryStrings.get(s) != null) {
            Object[] newList = (String[])this.b.queryStrings.get(s);
            if (!Arrays.deepEquals(list, newList)) {
                String[] s1 = new String[list.length + newList.length];
                System.arraycopy(list, 0, s1, 0, list.length);
                System.arraycopy(newList, 0, s1, list.length, newList.length);
                return s1;
            }
            return list;
        }
        return list == null ? (String[])this.b.queryStrings.get(s) : list;
    }

    public String getProtocol() {
        return this.b.request.getProtocol();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.b.body.isEmpty()) {
            this.configureStream();
            return this.bis == null ? (this.isNotNoOps() ? this.b.request.getInputStream() : this.voidStream) : this.bis;
        }
        if (this.b.body.hasString()) {
            this.bis = new IS(new ByteArrayInputStream(this.b.body.asString().getBytes()));
        } else if (this.b.body.hasBytes()) {
            this.bis = new IS(new ByteArrayInputStream(this.b.body.asBytes(), this.b.body.offset, this.b.body.byteLength()));
        }
        return this.bis;
    }

    public BufferedReader getReader() throws IOException {
        if (this.b.body.isEmpty()) {
            this.configureReader();
            return this.br == null ? (this.isNotNoOps() ? this.b.request.getReader() : this.getVoidReader()) : this.br;
        }
        if (this.b.body.hasString()) {
            this.br = new BufferedReader(new StringReader(this.body().asString()));
        } else if (this.b.body.hasBytes()) {
            this.br = new BufferedReader(new StringReader(new String(this.body().asBytes(), this.body().byteOffset(), this.body().length)));
        }
        return this.br;
    }

    public String getRealPath(String path) {
        return this.b.request.getRealPath(path);
    }

    public AtmosphereRequest headers(Map<String, String> headers) {
        this.b.headers.putAll(headers);
        return this;
    }

    public AtmosphereRequest header(String name, String value) {
        this.b.headers.put(name, value);
        return this;
    }

    public AtmosphereRequest queryString(String qs) {
        if (qs == null) {
            return this;
        }
        if (!qs.isEmpty()) {
            QueryStringDecoder decoder = new QueryStringDecoder(this.getRequestURI() + "?" + qs);
            Map<String, List<String>> m = decoder.getParameters();
            HashMap<String, String[]> newM = new HashMap<String, String[]>();
            for (Map.Entry<String, List<String>> q : m.entrySet()) {
                newM.put(q.getKey(), q.getValue().toArray(new String[q.getValue().size()]));
            }
            this.b.queryStrings(newM);
        }
        this.b.queryString = qs;
        return this;
    }

    public Map<String, String> headersMap() {
        return this.b.headers;
    }

    public Map<String, String[]> queryStringsMap() {
        return this.b.queryStrings;
    }

    public AtmosphereRequest method(String m) {
        this.b.method(m);
        return this;
    }

    public AtmosphereRequest contentType(String m) {
        this.b.contentType(m);
        return this;
    }

    public AtmosphereRequest body(String body) {
        this.b.body = new Body(body, null, 0, 0);
        return this;
    }

    public AtmosphereRequest body(byte[] bytes) {
        this.b.body = new Body(null, bytes, 0, bytes.length);
        return this;
    }

    public AtmosphereRequest body(InputStream body) {
        this.bis = new IS(body);
        this.br = new BufferedReader(new InputStreamReader(body));
        return this;
    }

    public AtmosphereRequest body(Reader body) {
        this.bis = new IS(new ReaderInputStream(body));
        this.br = new BufferedReader(body);
        return this;
    }

    public Body body() {
        return this.b.body;
    }

    public AtmosphereRequest servletPath(String servletPath) {
        this.b.servletPath = servletPath;
        return this;
    }

    public AtmosphereRequest contextPath(String contextPath) {
        this.b.contextPath = contextPath;
        return this;
    }

    public AtmosphereRequest requestURI(String requestURI) {
        this.b.requestURI = requestURI;
        return this;
    }

    public void setAttribute(String s, Object o) {
        if (o == null) {
            this.removeAttribute(s);
            return;
        }
        this.b.localAttributes.put(s, o);
        if (this.isNotNoOps()) {
            try {
                this.b.request.setAttribute(s, o);
            }
            catch (NullPointerException ex) {
                logger.warn("", (Throwable)ex);
            }
        }
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.b.request.setCharacterEncoding(env);
    }

    public AsyncContext startAsync() {
        return this.b.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        return this.b.request.startAsync(request, response);
    }

    public AsyncContext getAsyncContext() {
        return this.b.request.getAsyncContext();
    }

    public Object getAttribute(String s) {
        return this.b.localAttributes.get(s) != null ? (Object)this.b.localAttributes.get(s) : (this.isNotNoOps() ? AtmosphereRequest.attributeWithoutException(this.b.request, s) : null);
    }

    public void removeAttribute(String name) {
        this.b.localAttributes.remove(name);
        if (this.isNotNoOps()) {
            this.b.request.removeAttribute(name);
        }
    }

    public Map<String, Object> attributes() {
        return this.b.localAttributes;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.b.webSocketFakeSession != null) {
            return this.b.webSocketFakeSession;
        }
        if (this.resource() != null) {
            HttpSession session = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast((Object)this.resource())).session;
            try {
                if (session != null) {
                    session.isNew();
                    return session;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            return this.b.request.getSession(create);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage() != null || ex.getMessage().equalsIgnoreCase("No Session Manager")) {
                return null;
            }
            throw ex;
        }
        catch (NullPointerException ex) {
            return this.b.request.getSession(create);
        }
    }

    public Principal getUserPrincipal() {
        return this.b.principal != null ? this.b.principal : this.b.request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.b.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.b.request.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.b.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.b.request.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return this.b.request.isUserInRole(role);
    }

    public void login(String username, String password) throws ServletException {
        this.b.request.login(username, password);
    }

    public void logout() throws ServletException {
        this.b.request.logout();
    }

    public String getRemoteAddr() {
        return this.isNotNoOps() ? this.b.request.getRemoteAddr() : (this.b.lazyRemote != null ? this.b.lazyRemote.getHostAddress() : this.b.remoteAddr);
    }

    public String getRemoteHost() {
        return this.isNotNoOps() ? this.b.request.getRemoteHost() : (this.b.lazyRemote != null ? this.b.lazyRemote.getHostName() : this.b.remoteHost);
    }

    public int getRemotePort() {
        return this.isNotNoOps() ? this.b.request.getRemotePort() : (this.b.lazyRemote != null ? this.b.lazyRemote.getPort() : this.b.remotePort);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.b.request.getRequestDispatcher(path);
    }

    public String getScheme() {
        return this.b.request.getScheme();
    }

    public String getServerName() {
        return this.b.serverName != "" ? this.b.serverName : this.b.request.getServerName();
    }

    public int getServerPort() {
        return this.b.serverPort != 0 ? this.b.serverPort : this.b.request.getServerPort();
    }

    public ServletContext getServletContext() {
        return this.b.request.getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.b.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        try {
            return this.b.request.isAsyncSupported();
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
            return false;
        }
    }

    public boolean isSecure() {
        return this.isNotNoOps() ? this.b.request.isSecure() : this.b.isSecure;
    }

    public String getLocalName() {
        return this.isNotNoOps() ? this.b.request.getLocalName() : (this.b.lazyLocal != null ? this.b.lazyLocal.getHostName() : this.b.localName);
    }

    public int getLocalPort() {
        return this.isNotNoOps() ? this.b.request.getLocalPort() : (this.b.lazyLocal != null ? this.b.lazyLocal.getPort() : this.b.localPort);
    }

    public String getLocalAddr() {
        return this.isNotNoOps() ? this.b.request.getLocalAddr() : (this.b.lazyLocal != null ? this.b.lazyLocal.getHostAddress() : this.b.localAddr);
    }

    private boolean isNotNoOps() {
        return !NoOpsRequest.class.isAssignableFrom(this.b.request.getClass());
    }

    public Locale getLocale() {
        return this.isNotNoOps() ? this.b.request.getLocale() : (this.b.locales.iterator().hasNext() ? (Locale)this.b.locales.iterator().next() : Locale.getDefault());
    }

    public AtmosphereResource resource() {
        return (AtmosphereResource)this.getAttribute(FrameworkConfig.ATMOSPHERE_RESOURCE);
    }

    public Enumeration<Locale> getLocales() {
        return this.isNotNoOps() ? this.b.request.getLocales() : Collections.enumeration(this.b.locales);
    }

    public boolean dispatchRequestAsynchronously() {
        return this.b.dispatchRequestAsynchronously;
    }

    public boolean isDestroyable() {
        return this.b.destroyable;
    }

    public AtmosphereRequest pathInfo(String pathInfo) {
        this.b.pathInfo = pathInfo;
        return this;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration e;
        HashSet<Object> l = new HashSet<Object>();
        l.addAll(this.b.localAttributes.keySet());
        Enumeration enumeration = e = this.isNotNoOps() ? this.b.request.getAttributeNames() : null;
        if (e != null) {
            while (e.hasMoreElements()) {
                l.add(e.nextElement());
            }
        }
        return Collections.enumeration(l);
    }

    private static Object attributeWithoutException(HttpServletRequest request, String attribute) {
        try {
            return request.getAttribute(attribute);
        }
        catch (NullPointerException ex) {
            logger.trace("Unexpected NPE", (Throwable)ex);
            return "";
        }
    }

    public String getCharacterEncoding() {
        return this.b.request.getCharacterEncoding() == null ? this.b.encoding : this.b.request.getCharacterEncoding();
    }

    public int getContentLength() {
        if (this.b.contentLength == null) {
            return this.b.request.getContentLength();
        }
        return this.b.contentLength.intValue();
    }

    public void destroy() {
        this.destroy(this.b.destroyable);
    }

    public void destroy(boolean force) {
        if (!force) {
            return;
        }
        this.b.localAttributes.clear();
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.b.headers.clear();
        this.b.queryStrings.clear();
    }

    public void setRequest(ServletRequest request) {
        super.setRequest(request);
        if (HttpServletRequest.class.isAssignableFrom(request.getClass())) {
            this.b.request = (HttpServletRequest)HttpServletRequest.class.cast(request);
        }
    }

    public static final AtmosphereRequest newInstance() {
        return new Builder().build();
    }

    public static final AtmosphereRequest wrap(HttpServletRequest request) {
        if (AtmosphereRequest.class.isAssignableFrom(request.getClass())) {
            return (AtmosphereRequest)((Object)AtmosphereRequest.class.cast(request));
        }
        Builder b = new Builder();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            b.localAttributes.put(s, AtmosphereRequest.attributeWithoutException(request, s));
        }
        return b.request(request).build();
    }

    public static final AtmosphereRequest cloneRequest(HttpServletRequest request, boolean loadInMemory, boolean copySession, boolean isDestroyable) {
        Builder b;
        Cookie[] cs = request.getCookies();
        Set<Cookie> hs = Collections.synchronizedSet(new HashSet());
        if (cs != null) {
            for (Cookie c : cs) {
                hs.add(c);
            }
        }
        boolean isWrapped = false;
        if (AtmosphereRequest.class.isAssignableFrom(request.getClass())) {
            b = ((AtmosphereRequest)((Object)AtmosphereRequest.class.cast((Object)request))).b;
            isWrapped = true;
        } else {
            b = new Builder();
            b.request(request);
        }
        HttpSession session = null;
        if (copySession && (session = request.getSession(true)) != null) {
            session = new FakeHttpSession(session);
        }
        b.servletPath(request.getServletPath()).pathInfo(request.getPathInfo()).contextPath(request.getContextPath()).requestURI(request.getRequestURI()).requestURL(request.getRequestURL().toString()).method(request.getMethod()).serverName(request.getServerName()).serverPort(request.getServerPort()).remoteAddr(request.getRemoteAddr()).remoteHost(request.getRemoteHost()).remotePort(request.getRemotePort()).destroyable(isDestroyable).cookies(hs).session(session).principal(request.getUserPrincipal()).authType(request.getAuthType()).isSSecure(request.isSecure());
        if (loadInMemory) {
            String s = (String)AtmosphereRequest.attributeWithoutException(request, FrameworkConfig.THROW_EXCEPTION_ON_CLONED_REQUEST);
            boolean throwException = s != null && Boolean.parseBoolean(s);
            NoOpsRequest r = new NoOpsRequest(throwException);
            if (isWrapped) {
                AtmosphereRequest.load(b.request, b);
            } else {
                AtmosphereRequest.load(request, b);
            }
            b.request(r);
        }
        return isWrapped ? (AtmosphereRequest)((Object)AtmosphereRequest.class.cast(request)) : b.build();
    }

    private static void load(HttpServletRequest request, Builder b) {
        String s;
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            b.headers.put(s, request.getHeader(s));
        }
        e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            b.localAttributes.put(s, AtmosphereRequest.attributeWithoutException(request, s));
        }
        e = request.getParameterNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            b.queryStrings.put(s, request.getParameterValues(s));
        }
        b.queryString = request.getQueryString();
        Enumeration l = request.getLocales();
        while (l.hasMoreElements()) {
            b.locale((Locale)l.nextElement());
        }
    }

    public String toString() {
        try {
            return "AtmosphereRequest{ method=" + this.getMethod() + " contextPath=" + this.getContextPath() + " servletPath=" + this.getServletPath() + " pathInfo=" + this.getPathInfo() + " requestURI=" + this.getRequestURI() + " requestURL=" + this.getRequestURL() + " AtmosphereResource UUID=" + (this.resource() != null ? this.resource().uuid() : "") + " destroyable=" + this.b.destroyable + '}';
        }
        catch (Exception e) {
            return "AtmosphereRequest{ contextPath=" + this.getContextPath() + " servletPath=" + this.getServletPath() + " pathInfo=" + this.getPathInfo() + " requestURI=" + this.getRequestURI() + " destroyable=" + this.b.destroyable + '}';
        }
    }

    public String requestURL() {
        return this.b.requestURL;
    }

    private static final class LazyComputation {
        private final Callable<InetSocketAddress> callable;
        private InetSocketAddress address;

        public LazyComputation(Callable<InetSocketAddress> callable) {
            this.callable = callable;
        }

        public InetSocketAddress address() {
            if (this.address == null) {
                try {
                    this.address = this.callable.call();
                }
                catch (Exception e) {
                    logger.warn("", (Throwable)e);
                }
            }
            return this.address;
        }

        public int getPort() {
            return this.address().getPort();
        }

        public String getHostAddress() {
            return this.address().getAddress().getHostAddress();
        }

        public String getHostName() {
            return this.address().getHostName();
        }
    }

    static final class NoOpsRequest
    implements HttpServletRequest {
        private boolean throwExceptionOnCloned;
        public HttpSession fake;
        private static final Enumeration<String> EMPTY_ENUM_STRING = Collections.enumeration(Collections.emptyList());
        private static final Enumeration<Locale> EMPTY_ENUM_LOCALE = Collections.enumeration(Collections.emptyList());
        private static final List<Part> EMPTY_ENUM_PART = Collections.emptyList();
        private static final Map<String, String[]> EMPTY_MAP_STRING = Collections.emptyMap();
        private static final String[] EMPTY_ARRAY = new String[0];
        private final StringBuffer EMPTY_STRING_BUFFER = new StringBuffer();
        private static final Cookie[] EMPTY_COOKIE = new Cookie[0];
        private volatile BufferedReader voidReader;
        private final ServletInputStream voidStream = new IS(new ByteArrayInputStream(new byte[0]));

        public NoOpsRequest() {
            this.throwExceptionOnCloned = false;
        }

        private BufferedReader getVoidReader() {
            if (this.voidReader == null) {
                this.voidReader = new BufferedReader(new StringReader(""));
            }
            return this.voidReader;
        }

        public NoOpsRequest(boolean throwExceptionOnCloned) {
            this.throwExceptionOnCloned = throwExceptionOnCloned;
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return false;
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return "";
        }

        public Cookie[] getCookies() {
            return EMPTY_COOKIE;
        }

        public long getDateHeader(String name) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return EMPTY_ENUM_STRING;
        }

        public Enumeration<String> getHeaders(String name) {
            return EMPTY_ENUM_STRING;
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return "GET";
        }

        public Part getPart(String name) throws IOException, ServletException {
            return null;
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return EMPTY_ENUM_PART;
        }

        public String getPathInfo() {
            return "";
        }

        public String getPathTranslated() {
            return "";
        }

        public String getQueryString() {
            return "";
        }

        public String getRemoteUser() {
            return "";
        }

        public String getRequestedSessionId() {
            return "";
        }

        public String getRequestURI() {
            return "/";
        }

        public StringBuffer getRequestURL() {
            return this.EMPTY_STRING_BUFFER;
        }

        public String getServletPath() {
            return "";
        }

        public HttpSession getSession() {
            return this.fake;
        }

        public HttpSession getSession(boolean create) {
            if (create && this.fake == null) {
                this.fake = new FakeHttpSession("", null, System.currentTimeMillis(), -1){

                    @Override
                    public void invalidate() {
                        NoOpsRequest.this.fake = null;
                        super.invalidate();
                    }
                };
            }
            return this.fake;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String role) {
            if (this.throwExceptionOnCloned) {
                throw new UnsupportedOperationException();
            }
            return false;
        }

        public void login(String username, String password) throws ServletException {
            if (this.throwExceptionOnCloned) {
                throw new ServletException();
            }
        }

        public void logout() throws ServletException {
            if (this.throwExceptionOnCloned) {
                throw new ServletException();
            }
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return EMPTY_ENUM_STRING;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return "text/plain";
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.voidStream;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return EMPTY_ENUM_LOCALE;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public String getLocalAddr() {
            return "";
        }

        public String getParameter(String name) {
            return "";
        }

        public Map<String, String[]> getParameterMap() {
            return EMPTY_MAP_STRING;
        }

        public Enumeration<String> getParameterNames() {
            return EMPTY_ENUM_STRING;
        }

        public String[] getParameterValues(String name) {
            return EMPTY_ARRAY;
        }

        public String getProtocol() {
            return "HTTP/1.1";
        }

        public BufferedReader getReader() throws IOException {
            return this.getVoidReader();
        }

        public String getRealPath(String path) {
            return path;
        }

        public String getRemoteAddr() {
            return "";
        }

        public String getRemoteHost() {
            return "";
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public String getScheme() {
            return "ws";
        }

        public String getServerName() {
            return "";
        }

        public int getServerPort() {
            return 0;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return true;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String name) {
        }

        public void setAttribute(String name, Object o) {
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        }

        public AsyncContext startAsync() {
            return null;
        }

        public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
            return null;
        }
    }

    private static final class IS
    extends ServletInputStream {
        private final InputStream innerStream;

        public IS(InputStream innerStream) {
            this.innerStream = innerStream;
        }

        public int read() throws IOException {
            return this.innerStream.read();
        }

        public int read(byte[] bytes) throws IOException {
            return this.innerStream.read(bytes);
        }

        public int read(byte[] bytes, int i, int i1) throws IOException {
            return this.innerStream.read(bytes, i, i1);
        }

        public long skip(long l) throws IOException {
            return this.innerStream.skip(l);
        }

        public int available() throws IOException {
            return this.innerStream.available();
        }

        public void close() throws IOException {
            this.innerStream.close();
        }

        public synchronized void mark(int i) {
            this.innerStream.mark(i);
        }

        public synchronized void reset() throws IOException {
            this.innerStream.reset();
        }

        public boolean markSupported() {
            return this.innerStream.markSupported();
        }
    }

    public static final class Body {
        private final String data;
        private final byte[] dataBytes;
        private final int offset;
        private final int length;
        private final boolean isEmpty;

        public Body(String data, byte[] dataBytes, int offset, int length) {
            this.data = data;
            this.dataBytes = dataBytes;
            this.offset = offset;
            this.length = length;
            this.isEmpty = data == null && dataBytes == null;
        }

        public boolean hasString() {
            return this.data != null;
        }

        public boolean hasBytes() {
            return this.dataBytes != null;
        }

        public String asString() {
            return this.data;
        }

        public byte[] asBytes() {
            return this.dataBytes;
        }

        public int byteOffset() {
            return this.offset;
        }

        public int byteLength() {
            return this.length;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }
    }

    public static final class Builder {
        private static final Body NULL_BODY = new Body(null, null, 0, 0);
        private HttpServletRequest request;
        private String pathInfo = "";
        private String encoding = "UTF-8";
        private String methodType;
        private String contentType;
        private Long contentLength;
        private Map<String, String> headers = Collections.synchronizedMap(new HashMap());
        private Map<String, String[]> queryStrings = Collections.synchronizedMap(new HashMap());
        private String servletPath = "";
        private String requestURI;
        private String requestURL;
        private Map<String, Object> localAttributes = new ConcurrentHashMap<String, Object>();
        private InputStream inputStream;
        private Reader reader;
        private String remoteAddr = "";
        private String remoteHost = "";
        private int remotePort = 0;
        private String localAddr = "";
        private String localName = "";
        private int localPort = 0;
        private boolean dispatchRequestAsynchronously;
        private boolean destroyable = true;
        private Set<Cookie> cookies = Collections.synchronizedSet(new HashSet());
        private final Set<Locale> locales = Collections.synchronizedSet(new HashSet());
        private Principal principal = null;
        private String authType = null;
        private String contextPath = "";
        private String serverName = "";
        private int serverPort = 0;
        private HttpSession webSocketFakeSession;
        private String queryString = "";
        private boolean isSecure = false;
        private LazyComputation lazyRemote = null;
        private LazyComputation lazyLocal = null;
        public Body body;

        public Builder destroyable(boolean destroyable) {
            this.destroyable = destroyable;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = Collections.synchronizedMap(headers);
            return this;
        }

        public Builder cookies(Set<Cookie> cookies) {
            this.cookies = cookies;
            return this;
        }

        public Builder dispatchRequestAsynchronously(boolean dispatchRequestAsynchronously) {
            this.dispatchRequestAsynchronously = dispatchRequestAsynchronously;
            return this;
        }

        public Builder remoteAddr(String remoteAddr) {
            this.remoteAddr = remoteAddr;
            return this;
        }

        public Builder remoteHost(String remoteHost) {
            this.remoteHost = remoteHost;
            return this;
        }

        public Builder remotePort(int remotePort) {
            this.remotePort = remotePort;
            return this;
        }

        public Builder localAddr(String localAddr) {
            this.localAddr = localAddr;
            return this;
        }

        public Builder localName(String localName) {
            this.localName = localName;
            return this;
        }

        public Builder localPort(int localPort) {
            this.localPort = localPort;
            return this;
        }

        public Builder remoteInetSocketAddress(Callable remoteAddr) {
            this.lazyRemote = new LazyComputation(remoteAddr);
            return this;
        }

        public Builder localInetSocketAddress(Callable localAddr) {
            this.lazyLocal = new LazyComputation(localAddr);
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.localAttributes = Collections.synchronizedMap(attributes);
            return this;
        }

        public Builder request(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public Builder servletPath(String servletPath) {
            this.servletPath = servletPath;
            return this;
        }

        public Builder requestURI(String requestURI) {
            this.requestURI = requestURI;
            return this;
        }

        public Builder requestURL(String requestURL) {
            this.requestURL = requestURL;
            return this;
        }

        public Builder pathInfo(String pathInfo) {
            this.pathInfo = pathInfo;
            return this;
        }

        public Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder body(byte[] dataBytes) {
            return this.body(dataBytes, 0, dataBytes.length);
        }

        public Builder body(byte[] dataBytes, int offset, int length) {
            this.body = new Body(null, dataBytes, offset, length);
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder method(String methodType) {
            this.methodType = methodType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder body(String data) {
            this.body = new Body(data, null, 0, 0);
            return this;
        }

        public Builder inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder reader(Reader reader) {
            this.reader = reader;
            return this;
        }

        public AtmosphereRequest build() {
            if (this.body == null) {
                this.body = NULL_BODY;
            }
            return new AtmosphereRequest(this);
        }

        public Builder queryStrings(Map<String, String[]> queryStrings) {
            this.queryStrings = Collections.synchronizedMap(queryStrings);
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath == null ? "" : contextPath;
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder session(HttpSession session) {
            if (this.request == null) {
                this.request = new NoOpsRequest();
            }
            if (NoOpsRequest.class.isAssignableFrom(this.request.getClass())) {
                ((NoOpsRequest)NoOpsRequest.class.cast((Object)this.request)).fake = session;
            } else {
                this.webSocketFakeSession = session;
            }
            return this;
        }

        public Builder principal(Principal principal) {
            this.principal = principal;
            return this;
        }

        public Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        public Builder isSSecure(boolean isSecure) {
            this.isSecure = isSecure;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locales.add(locale);
            return this;
        }

        public Builder userPrincipal(Principal userPrincipal) {
            this.principal = userPrincipal;
            return this;
        }
    }

    private static final class ByteInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream bis;

        public ByteInputStream(byte[] data, int offset, int length) {
            this.bis = new ByteArrayInputStream(data, offset, length);
        }

        public int read() throws IOException {
            return this.bis.read();
        }
    }
}

