/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Map;
import java.util.WeakHashMap;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProcessorFactory.class);
    private static WebSocketProcessorFactory factory;
    private final Map<AtmosphereFramework, WebSocketProcessor> processors = new WeakHashMap<AtmosphereFramework, WebSocketProcessor>();

    public static final synchronized WebSocketProcessorFactory getDefault() {
        if (factory == null) {
            factory = new WebSocketProcessorFactory();
        }
        return factory;
    }

    public Map<AtmosphereFramework, WebSocketProcessor> processors() {
        return this.processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocketProcessor getWebSocketProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = this.processors.get(framework);
        if (processor == null) {
            AtmosphereFramework atmosphereFramework = framework;
            synchronized (atmosphereFramework) {
                processor = this.createProcessor(framework);
                this.processors.put(framework, processor);
            }
        }
        return processor;
    }

    public synchronized void destroy() {
        for (WebSocketProcessor processor : this.processors.values()) {
            processor.destroy();
        }
        this.processors.clear();
    }

    private WebSocketProcessor createProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = null;
        String webSocketProcessorName = framework.getWebSocketProcessorClassName();
        if (!webSocketProcessorName.equalsIgnoreCase(DefaultWebSocketProcessor.class.getName())) {
            try {
                processor = framework.newClassInstance(WebSocketProcessor.class, IOUtils.loadClass(this.getClass(), webSocketProcessorName));
            }
            catch (Exception ex) {
                logger.error("Unable to create {}", (Object)webSocketProcessorName);
                processor = new DefaultWebSocketProcessor();
            }
        }
        if (processor == null) {
            processor = new DefaultWebSocketProcessor();
        }
        processor.configure(framework.getAtmosphereConfig());
        return processor;
    }
}

