/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet30CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Servlet30CometSupport.class);

    public Servlet30CometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return super.getContainerName() + " using javax.servlet/3.0";
    }

    @Override
    public Action service(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        Action nextAction;
        Action action = this.suspended(request, response);
        if (action.type() == Action.TYPE.SUSPEND) {
            this.suspend(action, request, response);
        } else if (action.type() == Action.TYPE.RESUME && (nextAction = this.resumed(request, response)).type() == Action.TYPE.SUSPEND) {
            this.suspend(action, request, response);
        }
        return action;
    }

    private void suspend(Action action, AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (!req.isAsyncStarted() && !Utils.webSocketEnabled(req)) {
            AsyncContext asyncContext = req.startAsync((ServletRequest)req, (ServletResponse)res);
            asyncContext.addListener((AsyncListener)new CometListener(this, res.uuid()));
            if (action.timeout() != -1L) {
                asyncContext.setTimeout(action.timeout());
            } else {
                asyncContext.setTimeout(Integer.MAX_VALUE);
            }
            req.setAttribute("org.atmosphere.container.asyncContext", asyncContext);
        }
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope()) {
            this.endAsyncContext(r.getRequest(false));
        }
    }

    @Override
    public AsyncSupport complete(AtmosphereResourceImpl r) {
        this.endAsyncContext(r.getRequest(false));
        return null;
    }

    public void endAsyncContext(AtmosphereRequest request) {
        AsyncContext asyncContext;
        Object attribute = null;
        try {
            attribute = request.getAttribute("org.atmosphere.container.asyncContext");
        }
        catch (Exception e) {
            logger.warn("Exception occurred in getting attribute from request object", (Throwable)e);
        }
        if (attribute != null && attribute instanceof AsyncContext && (asyncContext = (AsyncContext)attribute) != null) {
            try {
                asyncContext.complete();
            }
            catch (IllegalStateException ex) {
                try {
                    logger.trace("Already resumed!", (Throwable)ex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)Long.class.cast(req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity")) == -1L) {
            this.endAsyncContext(req);
        }
        return action;
    }

    private static final class CometListener
    implements AsyncListener {
        private final AsynchronousProcessor p;
        private final String uuid;

        public CometListener() {
            this.uuid = "-1";
            this.p = null;
        }

        public CometListener(AsynchronousProcessor processor, String uuid) {
            this.p = processor;
            this.uuid = uuid;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            logger.trace("Resumed (completed): event: {}", (Object)this.uuid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(AsyncEvent event) throws IOException {
            logger.trace("onTimeout(): event: {}", (Object)event.getAsyncContext().getRequest());
            if (this.p == null) {
                logger.error("Invalid state - CometListener");
                return;
            }
            AsyncContext asyncContext = event.getAsyncContext();
            try {
                this.p.timedout((AtmosphereRequest)asyncContext.getRequest(), (AtmosphereResponse)asyncContext.getResponse());
            }
            catch (ServletException ex) {
                logger.warn("onTimeout(): failed timing out comet response: " + event.getAsyncContext().getResponse(), (Throwable)ex);
            }
            finally {
                try {
                    asyncContext.complete();
                }
                catch (IllegalStateException ex) {
                    logger.trace("", (Throwable)ex);
                }
            }
        }

        public void onError(AsyncEvent event) {
            logger.trace("onError(): event: {}", (Object)event.getAsyncContext().getResponse());
            if (this.p == null) {
                logger.error("Invalid state - CometListener");
                return;
            }
            try {
                this.p.cancelled((AtmosphereRequest)event.getAsyncContext().getRequest(), (AtmosphereResponse)event.getAsyncContext().getResponse());
            }
            catch (Throwable ex) {
                logger.warn("failed cancelling comet response: " + event.getAsyncContext().getResponse(), ex);
            }
        }

        public void onStartAsync(AsyncEvent event) {
            logger.trace("onStartAsync(): event: {}", (Object)event.getAsyncContext().getResponse());
        }
    }
}

