/*
 * Decompiled with CFR 0.152.
 */
package org.audit4j.integration.spring;

import java.util.List;
import org.audit4j.core.AuditManager;
import org.audit4j.core.Configuration;
import org.audit4j.core.MetaData;
import org.audit4j.core.dto.EventBuilder;
import org.audit4j.core.filter.AuditEventFilter;
import org.audit4j.core.handler.Handler;
import org.audit4j.core.layout.Layout;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SpringAudit4jConfig
implements InitializingBean,
DisposableBean {
    private Layout layout;
    private List<Handler> handlers;
    private MetaData metaData;
    private List<AuditEventFilter> filters;

    public void afterPropertiesSet() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setLayout(this.layout);
        configuration.setHandlers(this.handlers);
        configuration.setMetaData(this.metaData);
        configuration.setFilters(this.filters);
        AuditManager manager = AuditManager.getConfigurationInstance((Configuration)configuration);
        manager.audit(new EventBuilder().addAction("Init Audit4j").addActor("Audit4j").addOrigin("Audit4j").addField("init", (Object)"init").build());
    }

    public void destroy() throws Exception {
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
    }

    public void setFilters(List<AuditEventFilter> filters) {
        this.filters = filters;
    }
}

