/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.EventStreamUtils;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.NoOpEventUpcaster;
import org.axonframework.serialization.xml.XStreamSerializer;

public abstract class AbstractEventStorageEngine
implements EventStorageEngine {
    private final Serializer snapshotSerializer;
    protected final EventUpcaster upcasterChain;
    private final PersistenceExceptionResolver persistenceExceptionResolver;
    private final Serializer eventSerializer;
    private final Predicate<? super DomainEventData<?>> snapshotFilter;

    protected AbstractEventStorageEngine(Builder builder) {
        builder.validate();
        this.snapshotSerializer = (Serializer)builder.snapshotSerializer.get();
        this.upcasterChain = builder.upcasterChain;
        this.persistenceExceptionResolver = builder.persistenceExceptionResolver;
        this.eventSerializer = (Serializer)builder.eventSerializer.get();
        this.snapshotFilter = builder.snapshotFilter;
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        Stream<? extends TrackedEventData<?>> input = this.readEventData(trackingToken, mayBlock);
        return EventUtils.upcastAndDeserializeTrackedEvents(input, (Serializer)this.eventSerializer, (EventUpcaster)this.upcasterChain);
    }

    @Override
    public DomainEventStream readEvents(String aggregateIdentifier, long firstSequenceNumber) {
        Stream<? extends DomainEventData<?>> input = this.readEventData(aggregateIdentifier, firstSequenceNumber);
        return EventStreamUtils.upcastAndDeserializeDomainEvents(input, this.eventSerializer, this.upcasterChain);
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(String aggregateIdentifier) {
        return this.readSnapshotData(aggregateIdentifier).filter(this.snapshotFilter).map(snapshot -> EventStreamUtils.upcastAndDeserializeDomainEvents(Stream.of(snapshot), this.snapshotSerializer, this.upcasterChain)).flatMap(DomainEventStream::asStream).findFirst().map(event -> event);
    }

    @Override
    public void appendEvents(List<? extends EventMessage<?>> events) {
        this.appendEvents(events, this.eventSerializer);
    }

    @Override
    public void storeSnapshot(DomainEventMessage<?> snapshot) {
        this.storeSnapshot(snapshot, this.snapshotSerializer);
    }

    protected void handlePersistenceException(Exception exception, EventMessage<?> failedEvent) {
        String eventDescription;
        if (failedEvent instanceof DomainEventMessage) {
            DomainEventMessage failedDomainEvent = (DomainEventMessage)failedEvent;
            eventDescription = String.format("An event for aggregate [%s] at sequence [%d]", failedDomainEvent.getAggregateIdentifier(), failedDomainEvent.getSequenceNumber());
        } else {
            eventDescription = String.format("An event with identifier [%s]", failedEvent.getIdentifier());
        }
        if (this.persistenceExceptionResolver != null && this.persistenceExceptionResolver.isDuplicateKeyViolation(exception)) {
            throw new ConcurrencyException(eventDescription + " was already inserted", (Throwable)exception);
        }
        throw new EventStoreException(eventDescription + " could not be persisted", exception);
    }

    protected abstract void appendEvents(List<? extends EventMessage<?>> var1, Serializer var2);

    protected abstract void storeSnapshot(DomainEventMessage<?> var1, Serializer var2);

    protected abstract Stream<? extends DomainEventData<?>> readEventData(String var1, long var2);

    protected abstract Stream<? extends TrackedEventData<?>> readEventData(TrackingToken var1, boolean var2);

    protected abstract Stream<? extends DomainEventData<?>> readSnapshotData(String var1);

    public Serializer getSnapshotSerializer() {
        return this.snapshotSerializer;
    }

    public Serializer getEventSerializer() {
        return this.eventSerializer;
    }

    public static abstract class Builder {
        private Supplier<Serializer> snapshotSerializer = XStreamSerializer::defaultSerializer;
        protected EventUpcaster upcasterChain = NoOpEventUpcaster.INSTANCE;
        private PersistenceExceptionResolver persistenceExceptionResolver;
        private Supplier<Serializer> eventSerializer = XStreamSerializer::defaultSerializer;
        private Predicate<? super DomainEventData<?>> snapshotFilter = i -> true;

        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            BuilderUtils.assertNonNull((Object)snapshotSerializer, (String)"The Snapshot Serializer may not be null");
            this.snapshotSerializer = () -> snapshotSerializer;
            return this;
        }

        public Builder upcasterChain(EventUpcaster upcasterChain) {
            BuilderUtils.assertNonNull((Object)upcasterChain, (String)"EventUpcaster may not be null");
            this.upcasterChain = upcasterChain;
            return this;
        }

        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            this.persistenceExceptionResolver = persistenceExceptionResolver;
            return this;
        }

        public Builder eventSerializer(Serializer eventSerializer) {
            BuilderUtils.assertNonNull((Object)eventSerializer, (String)"The Event Serializer may not be null");
            this.eventSerializer = () -> eventSerializer;
            return this;
        }

        public Builder snapshotFilter(Predicate<? super DomainEventData<?>> snapshotFilter) {
            BuilderUtils.assertNonNull(snapshotFilter, (String)"The snapshotFilter may not be null");
            this.snapshotFilter = snapshotFilter;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

