/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.micrometer.reservoir.SlidingTimeWindowReservoir;
import org.axonframework.monitoring.MessageMonitor;

public class CapacityMonitor
implements MessageMonitor<Message<?>> {
    private final Map<String, SlidingTimeWindowReservoir> timeWindowedDurationMeasurementsMap = new ConcurrentHashMap<String, SlidingTimeWindowReservoir>();
    private final TimeUnit timeUnit;
    private final Clock clock;
    private final long window;
    private final String meterNamePrefix;
    private final MeterRegistry meterRegistry;
    private final Function<Message<?>, Iterable<Tag>> tagsBuilder;

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry) {
        return CapacityMonitor.buildMonitor(meterNamePrefix, meterRegistry, 10L, TimeUnit.MINUTES);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return CapacityMonitor.buildMonitor(meterNamePrefix, meterRegistry, 10L, TimeUnit.MINUTES, tagsBuilder);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, long window, TimeUnit timeUnit) {
        return CapacityMonitor.buildMonitor(meterNamePrefix, meterRegistry, window, timeUnit, Clock.SYSTEM);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, long window, TimeUnit timeUnit, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return CapacityMonitor.buildMonitor(meterNamePrefix, meterRegistry, window, timeUnit, Clock.SYSTEM, tagsBuilder);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, long window, TimeUnit timeUnit, Clock clock) {
        return new CapacityMonitor(window, timeUnit, clock, meterNamePrefix, meterRegistry);
    }

    public static CapacityMonitor buildMonitor(String meterNamePrefix, MeterRegistry meterRegistry, long window, TimeUnit timeUnit, Clock clock, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        return new CapacityMonitor(window, timeUnit, clock, meterNamePrefix, meterRegistry, tagsBuilder);
    }

    private CapacityMonitor(long window, TimeUnit timeUnit, Clock clock, String meterNamePrefix, MeterRegistry meterRegistry) {
        this(window, timeUnit, clock, meterNamePrefix, meterRegistry, message -> Tags.empty());
    }

    private CapacityMonitor(long window, TimeUnit timeUnit, Clock clock, String meterNamePrefix, MeterRegistry meterRegistry, Function<Message<?>, Iterable<Tag>> tagsBuilder) {
        this.timeUnit = timeUnit;
        this.clock = clock;
        this.window = window;
        this.meterNamePrefix = meterNamePrefix;
        this.meterRegistry = meterRegistry;
        this.tagsBuilder = tagsBuilder;
    }

    private SlidingTimeWindowReservoir createIfAbsent(String meterNamePrefix, Tags tags, long window, TimeUnit timeUnit, Clock clock) {
        String key = meterNamePrefix + tags.stream().map(tag -> tag.getKey() + tag.getValue()).reduce(String::concat).orElse("");
        this.timeWindowedDurationMeasurementsMap.putIfAbsent(key, new SlidingTimeWindowReservoir(window, timeUnit, clock));
        return this.timeWindowedDurationMeasurementsMap.get(key);
    }

    public MessageMonitor.MonitorCallback onMessageIngested(Message<?> message) {
        Iterable<Tag> tags = this.tagsBuilder.apply(message);
        final SlidingTimeWindowReservoir timeWindowedDurationMeasurements = this.createIfAbsent(this.meterNamePrefix, Tags.of(tags), this.window, this.timeUnit, this.clock);
        this.meterRegistry.gauge(this.meterNamePrefix + ".capacity", tags, (Object)this, value -> this.calculateCapacity(timeWindowedDurationMeasurements));
        final long start = this.clock.monotonicTime();
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                timeWindowedDurationMeasurements.update(CapacityMonitor.this.clock.monotonicTime() - start);
            }

            public void reportFailure(Throwable cause) {
                timeWindowedDurationMeasurements.update(CapacityMonitor.this.clock.monotonicTime() - start);
            }

            public void reportIgnored() {
                timeWindowedDurationMeasurements.update(CapacityMonitor.this.clock.monotonicTime() - start);
            }
        };
    }

    private double calculateCapacity(SlidingTimeWindowReservoir timeWindowedDurationMeasurements) {
        long totalProcessTime = timeWindowedDurationMeasurements.getMeasurements().stream().reduce(0L, Long::sum);
        return (double)totalProcessTime / (double)this.timeUnit.toNanos(this.window);
    }
}

