/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import java.util.Arrays;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.jvm.values.utils.GetFunction;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="enumerate", args={@Argument(name="arr", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.TUPLE)}, isPublic=true)
public class Enumerate {
    public static ArrayValue enumerate(Strand strand, ArrayValue arr) {
        GetFunction getFn;
        BTupleType elemType;
        BType arrType = arr.getType();
        int size = arr.size();
        switch (arrType.getTag()) {
            case 20: {
                elemType = new BTupleType(Arrays.asList(BTypes.typeInt, arr.elementType));
                getFn = ArrayValue::get;
                break;
            }
            case 31: {
                BUnionType tupElemType = new BUnionType(((BTupleType)arrType).getTupleTypes());
                elemType = new BTupleType(Arrays.asList(BTypes.typeInt, tupElemType));
                getFn = ArrayValue::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError((BType)arrType, (String)"enumerate()");
            }
        }
        BArrayType newArrType = new BArrayType((BType)elemType);
        ArrayValue newArr = new ArrayValue((BType)newArrType);
        for (int i = 0; i < size; ++i) {
            ArrayValue entry = new ArrayValue((BType)elemType);
            entry.add(0L, (Object)i);
            entry.add(1L, getFn.get(arr, (long)i));
            newArr.add((long)i, (Object)entry);
        }
        return newArr;
    }
}

