/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import java.util.ArrayList;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", version="1.1.0", functionName="fromBase16", args={@Argument(name="str", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.UNION)}, isPublic=true)
public class FromBase16 {
    public static Object fromBase16(Strand strand, BString str) {
        if (str.length() % 2 != 0) {
            return BallerinaErrors.createError((String)"Invalid base16 string", (String)("Expected an even length string, but the length of the string was: " + str.length()));
        }
        char[] chars = str.getValue().toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        ArrayList<Character> invalidChars = new ArrayList<Character>();
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            int upperHalf = Character.digit(chars[i], 16);
            int lowerHalf = Character.digit(chars[i + 1], 16);
            if (upperHalf < 0) {
                invalidChars.add(Character.valueOf(chars[i]));
            }
            if (lowerHalf < 0) {
                invalidChars.add(Character.valueOf(chars[i]));
            }
            bytes[j] = (byte)(upperHalf << 4 | lowerHalf);
            i += 2;
            ++j;
        }
        if (!invalidChars.isEmpty()) {
            return BallerinaErrors.createError((String)"Invalid base16 string", (String)("Invalid character(s): " + ((Object)invalidChars).toString()));
        }
        return new ArrayValueImpl(bytes);
    }
}

