/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import java.util.ArrayList;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", version="1.1.0", functionName="slice", args={@Argument(name="arr", type=TypeKind.ARRAY), @Argument(name="startIndex", type=TypeKind.INT), @Argument(name="endIndex", type=TypeKind.INT)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class Slice {
    public static ArrayValue slice(Strand strand, ArrayValue arr, long startIndex, long endIndex) {
        ArrayValueImpl slicedArr;
        int size = arr.size();
        if (startIndex < 0L) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, (Object[])new Object[]{startIndex, size});
        }
        if (endIndex > (long)size) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, (Object[])new Object[]{endIndex, size});
        }
        long sliceSize = endIndex - startIndex;
        if (sliceSize < 0L) {
            throw BLangExceptionHelper.getRuntimeException((RuntimeErrors)RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, (Object[])new Object[]{sliceSize, size});
        }
        BType arrType = arr.getType();
        switch (arrType.getTag()) {
            case 20: {
                slicedArr = ((ArrayValueImpl)arr).slice(startIndex, endIndex);
                break;
            }
            case 32: {
                BTupleType tupleType = (BTupleType)arrType;
                ArrayList<BType> memTypes = new ArrayList<BType>(tupleType.getTupleTypes());
                BType restType = tupleType.getRestType();
                if (restType != null) {
                    memTypes.add(restType);
                }
                BUnionType unionType = new BUnionType(memTypes);
                BArrayType slicedArrType = new BArrayType((BType)unionType, (int)(endIndex - startIndex));
                slicedArr = new ArrayValueImpl(slicedArrType);
                long i = startIndex;
                long j = 0L;
                while (i < endIndex) {
                    slicedArr.add(j, arr.getRefValue(i));
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError((BType)arrType, (String)"slice()");
            }
        }
        return slicedArr;
    }
}

