/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.values.BArray;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.langlib.array.utils.ArrayUtils;
import org.ballerinalang.langlib.array.utils.GetFunction;

public class Enumerate {
    public static BArray enumerate(BArray arr) {
        GetFunction getFn;
        TupleType elemType;
        Type arrType = arr.getType();
        int size = arr.size();
        switch (arrType.getTag()) {
            case 20: {
                elemType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, arr.getElementType()));
                getFn = BArray::get;
                break;
            }
            case 32: {
                TupleType tupleType = (TupleType)arrType;
                UnionType tupElemType = TypeCreator.createUnionType((List)tupleType.getTupleTypes(), (int)tupleType.getTypeFlags());
                elemType = TypeCreator.createTupleType(Arrays.asList(PredefinedTypes.TYPE_INT, tupElemType));
                getFn = BArray::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "enumerate()");
            }
        }
        ArrayType newArrType = TypeCreator.createArrayType((Type)elemType);
        BArray newArr = ValueCreator.createArrayValue((ArrayType)newArrType);
        for (int i = 0; i < size; ++i) {
            BArray entry = ValueCreator.createTupleValue((TupleType)elemType);
            entry.add(0L, (Object)i);
            entry.add(1L, getFn.get(arr, i));
            newArr.add((long)i, (Object)entry);
        }
        return newArr;
    }
}

